/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.logging;

import java.time.ZoneId;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.logging.NotionLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0002J\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lnotion/api/v1/logging/StdoutLogger;", "Lnotion/api/v1/logging/NotionLogger;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "buildMessage", "level", "message", "debug", "", "e", "", "error", "info", "isDebugEnabled", "", "now", "warn", "notion-sdk-jvm-core"})
public final class StdoutLogger
implements NotionLogger {
    @NotNull
    private final String name;

    @JvmOverloads
    public StdoutLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    public /* synthetic */ StdoutLogger(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string2 = StdoutLogger.class.getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StdoutLogger::class.java.canonicalName");
            string = string2;
        }
        this(string);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    private final String now() {
        String string = new Date().toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Date().toInstant().atZon\u2026fsetDateTime().toString()");
        return string;
    }

    private final String buildMessage(String level, String message) {
        return this.now() + ' ' + level + ' ' + this.name + " - " + message;
    }

    @Override
    public void debug(@NotNull String message, @Nullable Throwable e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            System.out.println((Object)this.buildMessage("DEBUG", message));
            Throwable throwable = e;
            if (throwable == null) break block0;
            throwable.printStackTrace();
        }
    }

    @Override
    public void info(@NotNull String message, @Nullable Throwable e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            System.out.println((Object)this.buildMessage("INFO", message));
            Throwable throwable = e;
            if (throwable == null) break block0;
            throwable.printStackTrace();
        }
    }

    @Override
    public void warn(@NotNull String message, @Nullable Throwable e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            System.out.println((Object)this.buildMessage("WARN", message));
            Throwable throwable = e;
            if (throwable == null) break block0;
            throwable.printStackTrace();
        }
    }

    @Override
    public void error(@NotNull String message, @Nullable Throwable e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            System.out.println((Object)this.buildMessage("ERROR", message));
            Throwable throwable = e;
            if (throwable == null) break block0;
            throwable.printStackTrace();
        }
    }

    @Override
    public void debug(@NotNull String message) {
        NotionLogger.DefaultImpls.debug(this, message);
    }

    @Override
    public void info(@NotNull String message) {
        NotionLogger.DefaultImpls.info(this, message);
    }

    @Override
    public void warn(@NotNull String message) {
        NotionLogger.DefaultImpls.warn(this, message);
    }

    @Override
    public void error(@NotNull String message) {
        NotionLogger.DefaultImpls.error(this, message);
    }

    @JvmOverloads
    public StdoutLogger() {
        this(null, 1, null);
    }
}

