/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.endpoint.EndpointsSupport;
import notion.api.v1.exception.NotionAPIError;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.json.NotionJsonSerializer;
import notion.api.v1.logging.NotionLogger;
import notion.api.v1.model.users.User;
import notion.api.v1.model.users.Users;
import notion.api.v1.request.users.ListUsersRequest;
import notion.api.v1.request.users.RetrieveUserRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016J%\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001eH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lnotion/api/v1/endpoint/UsersSupport;", "Lnotion/api/v1/endpoint/EndpointsSupport;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "httpClient", "Lnotion/api/v1/http/NotionHttpClient;", "getHttpClient", "()Lnotion/api/v1/http/NotionHttpClient;", "jsonSerializer", "Lnotion/api/v1/json/NotionJsonSerializer;", "getJsonSerializer", "()Lnotion/api/v1/json/NotionJsonSerializer;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "getLogger", "()Lnotion/api/v1/logging/NotionLogger;", "listUsers", "Lnotion/api/v1/model/users/Users;", "pageSize", "", "startCursor", "(Ljava/lang/Integer;Ljava/lang/String;)Lnotion/api/v1/model/users/Users;", "request", "Lnotion/api/v1/request/users/ListUsersRequest;", "retrieveBotUser", "Lnotion/api/v1/model/users/User;", "retrieveUser", "userId", "Lnotion/api/v1/request/users/RetrieveUserRequest;", "notion-sdk-jvm-core"})
public interface UsersSupport
extends EndpointsSupport {
    @NotNull
    public NotionHttpClient getHttpClient();

    @NotNull
    public NotionJsonSerializer getJsonSerializer();

    @NotNull
    public NotionLogger getLogger();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public User retrieveBotUser();

    @NotNull
    public User retrieveUser(@NotNull String var1);

    @NotNull
    public User retrieveUser(@NotNull RetrieveUserRequest var1);

    @NotNull
    public Users listUsers();

    @NotNull
    public Users listUsers(@Nullable Integer var1, @Nullable String var2);

    @NotNull
    public Users listUsers(@NotNull ListUsersRequest var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static User retrieveBotUser(@NotNull UsersSupport $this) {
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.get$default($this.getHttpClient(), $this.getLogger(), $this.getBaseUrl() + "/users/me", null, $this.buildRequestHeaders(MapsKt.emptyMap()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return $this.getJsonSerializer().toUser(httpResponse.getBody());
            }
            throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static User retrieveUser(@NotNull UsersSupport $this, @NotNull String userId) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            return $this.retrieveUser(new RetrieveUserRequest(userId));
        }

        @NotNull
        public static User retrieveUser(@NotNull UsersSupport $this, @NotNull RetrieveUserRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.get$default($this.getHttpClient(), $this.getLogger(), $this.getBaseUrl() + "/users/" + $this.urlEncode(request.getUserId()), null, $this.buildRequestHeaders(MapsKt.emptyMap()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return $this.getJsonSerializer().toUser(httpResponse.getBody());
            }
            throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Users listUsers(@NotNull UsersSupport $this) {
            return $this.listUsers(new ListUsersRequest(null, null));
        }

        @NotNull
        public static Users listUsers(@NotNull UsersSupport $this, @Nullable Integer pageSize, @Nullable String startCursor) {
            return $this.listUsers(new ListUsersRequest(startCursor, pageSize));
        }

        public static /* synthetic */ Users listUsers$default(UsersSupport usersSupport, Integer n, String string, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: listUsers");
            }
            if ((n2 & 1) != 0) {
                n = null;
            }
            if ((n2 & 2) != 0) {
                string = null;
            }
            return usersSupport.listUsers(n, string);
        }

        @NotNull
        public static Users listUsers(@NotNull UsersSupport $this, @NotNull ListUsersRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = $this.getHttpClient().get($this.getLogger(), $this.getBaseUrl() + "/users", request.buildPaginationParams(), $this.buildRequestHeaders(MapsKt.emptyMap()));
            if (httpResponse.getStatus() == 200) {
                return $this.getJsonSerializer().toUsers(httpResponse.getBody());
            }
            throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull UsersSupport $this, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            return EndpointsSupport.DefaultImpls.buildRequestHeaders($this, additionalOnes);
        }

        @NotNull
        public static String urlEncode(@NotNull UsersSupport $this, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return EndpointsSupport.DefaultImpls.urlEncode($this, value);
        }

        @NotNull
        public static Map<String, String> contentTypeJson(@NotNull UsersSupport $this) {
            return EndpointsSupport.DefaultImpls.contentTypeJson($this);
        }
    }
}

