/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import notion.api.v1.endpoint.EndpointsSupport;
import notion.api.v1.exception.NotionOAuthAPIError;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.json.NotionJsonSerializer;
import notion.api.v1.logging.NotionLogger;
import notion.api.v1.model.oauth.OAuthTokenResult;
import notion.api.v1.request.oauth.ExchangeAuthCodeRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005\u00a8\u0006\u001e"}, d2={"Lnotion/api/v1/endpoint/OAuthSupport;", "Lnotion/api/v1/endpoint/EndpointsSupport;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "clientId", "getClientId", "clientSecret", "getClientSecret", "httpClient", "Lnotion/api/v1/http/NotionHttpClient;", "getHttpClient", "()Lnotion/api/v1/http/NotionHttpClient;", "jsonSerializer", "Lnotion/api/v1/json/NotionJsonSerializer;", "getJsonSerializer", "()Lnotion/api/v1/json/NotionJsonSerializer;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "getLogger", "()Lnotion/api/v1/logging/NotionLogger;", "redirectUri", "getRedirectUri", "exchangeAuthCode", "Lnotion/api/v1/model/oauth/OAuthTokenResult;", "code", "state", "request", "Lnotion/api/v1/request/oauth/ExchangeAuthCodeRequest;", "notion-sdk-jvm-core"})
public interface OAuthSupport
extends EndpointsSupport {
    @Nullable
    public String getClientId();

    @Nullable
    public String getClientSecret();

    @Nullable
    public String getRedirectUri();

    @NotNull
    public NotionHttpClient getHttpClient();

    @NotNull
    public NotionJsonSerializer getJsonSerializer();

    @NotNull
    public NotionLogger getLogger();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public OAuthTokenResult exchangeAuthCode(@NotNull String var1, @NotNull String var2);

    @NotNull
    public OAuthTokenResult exchangeAuthCode(@NotNull ExchangeAuthCodeRequest var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static OAuthTokenResult exchangeAuthCode(@NotNull OAuthSupport $this, @NotNull String code, @NotNull String state) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            String string = $this.getRedirectUri();
            Intrinsics.checkNotNull((Object)string);
            return $this.exchangeAuthCode(new ExchangeAuthCodeRequest(null, code, state, string, 1, null));
        }

        @NotNull
        public static OAuthTokenResult exchangeAuthCode(@NotNull OAuthSupport $this, @NotNull ExchangeAuthCodeRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if ($this.getRedirectUri() == null) {
                throw new IllegalStateException("Setting redirectUri to NotionClient is required");
            }
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] byArray = ($this.getClientId() + ':' + $this.getClientSecret()).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byArray2 = encoder.encode(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoder()\n           \u2026yteArray(Charsets.UTF_8))");
            byte[] byArray3 = byArray2;
            Charset charset = Charsets.UTF_8;
            String base64Value = new String(byArray3, charset);
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.postTextBody$default($this.getHttpClient(), $this.getLogger(), $this.getBaseUrl() + "/oauth/token", null, $this.getJsonSerializer().toJsonString(request), $this.buildRequestHeaders(MapsKt.plus($this.contentTypeJson(), (Pair)TuplesKt.to((Object)"Authorization", (Object)("Basic " + base64Value)))), 4, null);
            if (httpResponse.getStatus() == 200) {
                return $this.getJsonSerializer().toOAuthTokenResult(httpResponse.getBody());
            }
            throw new NotionOAuthAPIError($this.getJsonSerializer().toOAuthError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull OAuthSupport $this, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            return EndpointsSupport.DefaultImpls.buildRequestHeaders($this, additionalOnes);
        }

        @NotNull
        public static String urlEncode(@NotNull OAuthSupport $this, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return EndpointsSupport.DefaultImpls.urlEncode($this, value);
        }

        @NotNull
        public static Map<String, String> contentTypeJson(@NotNull OAuthSupport $this) {
            return EndpointsSupport.DefaultImpls.contentTypeJson($this);
        }
    }
}

