/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.endpoint.EndpointsSupport;
import notion.api.v1.exception.NotionAPIError;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.json.NotionJsonSerializer;
import notion.api.v1.logging.NotionLogger;
import notion.api.v1.model.comments.Comment;
import notion.api.v1.model.comments.Comments;
import notion.api.v1.model.pages.PageParent;
import notion.api.v1.model.pages.PageProperty;
import notion.api.v1.request.comments.CreateCommentRequest;
import notion.api.v1.request.comments.RetrieveCommentsRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010!J-\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010#J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lnotion/api/v1/endpoint/CommentsSupport;", "Lnotion/api/v1/endpoint/EndpointsSupport;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "httpClient", "Lnotion/api/v1/http/NotionHttpClient;", "getHttpClient", "()Lnotion/api/v1/http/NotionHttpClient;", "jsonSerializer", "Lnotion/api/v1/json/NotionJsonSerializer;", "getJsonSerializer", "()Lnotion/api/v1/json/NotionJsonSerializer;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "getLogger", "()Lnotion/api/v1/logging/NotionLogger;", "createComment", "Lnotion/api/v1/model/comments/Comment;", "discussionId", "richText", "", "Lnotion/api/v1/model/pages/PageProperty$RichText;", "parent", "Lnotion/api/v1/model/pages/PageParent;", "comment", "Lnotion/api/v1/request/comments/CreateCommentRequest;", "retrieveComments", "Lnotion/api/v1/model/comments/Comments;", "blockId", "pageSize", "", "(Ljava/lang/String;Ljava/lang/Integer;)Lnotion/api/v1/model/comments/Comments;", "startCursor", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lnotion/api/v1/model/comments/Comments;", "request", "Lnotion/api/v1/request/comments/RetrieveCommentsRequest;", "notion-sdk-jvm-core"})
public interface CommentsSupport
extends EndpointsSupport {
    @NotNull
    public NotionHttpClient getHttpClient();

    @NotNull
    public NotionJsonSerializer getJsonSerializer();

    @NotNull
    public NotionLogger getLogger();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public Comment createComment(@NotNull PageParent var1, @NotNull List<PageProperty.RichText> var2);

    @NotNull
    public Comment createComment(@NotNull String var1, @NotNull List<PageProperty.RichText> var2);

    @NotNull
    public Comment createComment(@NotNull CreateCommentRequest var1);

    @NotNull
    public Comments retrieveComments(@NotNull String var1, @Nullable Integer var2);

    @NotNull
    public Comments retrieveComments(@NotNull String var1, @Nullable String var2, @Nullable Integer var3);

    @NotNull
    public Comments retrieveComments(@NotNull RetrieveCommentsRequest var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Comment createComment(@NotNull CommentsSupport $this, @NotNull PageParent parent, @NotNull List<PageProperty.RichText> richText) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter(richText, (String)"richText");
            return $this.createComment(new CreateCommentRequest(parent, null, richText, 2, null));
        }

        @NotNull
        public static Comment createComment(@NotNull CommentsSupport $this, @NotNull String discussionId, @NotNull List<PageProperty.RichText> richText) {
            Intrinsics.checkNotNullParameter((Object)discussionId, (String)"discussionId");
            Intrinsics.checkNotNullParameter(richText, (String)"richText");
            return $this.createComment(new CreateCommentRequest(null, discussionId, richText, 1, null));
        }

        @NotNull
        public static Comment createComment(@NotNull CommentsSupport $this, @NotNull CreateCommentRequest comment) {
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.postTextBody$default($this.getHttpClient(), $this.getLogger(), $this.getBaseUrl() + "/comments", null, $this.getJsonSerializer().toJsonString(comment), $this.buildRequestHeaders($this.contentTypeJson()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return $this.getJsonSerializer().toComment(httpResponse.getBody());
            }
            throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Comments retrieveComments(@NotNull CommentsSupport $this, @NotNull String blockId, @Nullable Integer pageSize) {
            Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
            return $this.retrieveComments(new RetrieveCommentsRequest(blockId, null, pageSize, 2, null));
        }

        public static /* synthetic */ Comments retrieveComments$default(CommentsSupport commentsSupport, String string, Integer n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: retrieveComments");
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            return commentsSupport.retrieveComments(string, n);
        }

        @NotNull
        public static Comments retrieveComments(@NotNull CommentsSupport $this, @NotNull String blockId, @Nullable String startCursor, @Nullable Integer pageSize) {
            Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
            return $this.retrieveComments(new RetrieveCommentsRequest(blockId, startCursor, pageSize));
        }

        public static /* synthetic */ Comments retrieveComments$default(CommentsSupport commentsSupport, String string, String string2, Integer n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: retrieveComments");
            }
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                n = null;
            }
            return commentsSupport.retrieveComments(string, string2, n);
        }

        @NotNull
        public static Comments retrieveComments(@NotNull CommentsSupport $this, @NotNull RetrieveCommentsRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = $this.getHttpClient().get($this.getLogger(), $this.getBaseUrl() + "/comments", request.toQuery(), $this.buildRequestHeaders(MapsKt.emptyMap()));
            if (httpResponse.getStatus() == 200) {
                return $this.getJsonSerializer().toComments(httpResponse.getBody());
            }
            throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull CommentsSupport $this, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            return EndpointsSupport.DefaultImpls.buildRequestHeaders($this, additionalOnes);
        }

        @NotNull
        public static String urlEncode(@NotNull CommentsSupport $this, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return EndpointsSupport.DefaultImpls.urlEncode($this, value);
        }

        @NotNull
        public static Map<String, String> contentTypeJson(@NotNull CommentsSupport $this) {
            return EndpointsSupport.DefaultImpls.contentTypeJson($this);
        }
    }
}

