/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.tomcat;

import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.tomcat.AbstractEmbeddedTomcatConfigurationBuilder;
import java.util.Objects;

abstract class AbstractEmbeddedTomcatConfiguration
extends AbstractConfiguration {
    static final String DEFAULT_CLASSPATH = "./target/classes";
    static final String DEFAULT_BASE_DIR = "./tomcat-work";
    static final boolean DEFAULT_KEEP_BASE_DIR = false;
    static final boolean DEFAULT_ENABLE_NAMING = true;
    static final boolean DEFAULT_FORCE_META_INF = true;
    private final String baseDir;
    private final boolean keepBaseDir;
    private final boolean enableNaming;
    private final boolean forceMetaInf;

    AbstractEmbeddedTomcatConfiguration(AbstractEmbeddedTomcatConfigurationBuilder<?, ?> builder) {
        super(builder.getClasspath(), builder.getPath(), builder.getWebapp(), builder.getPort(), builder.getEnvProperties(), builder.getHooks(), builder.getParentClassLoader(), builder.getOverrideDescriptor());
        this.baseDir = builder.getBaseDir();
        this.keepBaseDir = builder.isKeepBaseDir();
        this.enableNaming = builder.isEnableNaming();
        this.forceMetaInf = builder.isForceMetaInf();
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public boolean isKeepBaseDir() {
        return this.keepBaseDir;
    }

    public boolean isEnableNaming() {
        return this.enableNaming;
    }

    public boolean isForceMetaInf() {
        return this.forceMetaInf;
    }

    @Override
    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("port", this.getPort()).append("path", this.getPath()).append("webapp", this.getWebapp()).append("classpath", this.getClasspath()).append("overrideDescriptor", this.getOverrideDescriptor()).append("parentClassLoader", this.getParentClassLoader()).append("baseDir", this.baseDir).append("keepBaseDir", this.keepBaseDir).append("enableNaming", this.enableNaming).append("forceMetaInf", this.forceMetaInf).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractEmbeddedTomcatConfiguration) {
            AbstractEmbeddedTomcatConfiguration c = (AbstractEmbeddedTomcatConfiguration)o;
            return c.canEqual(this) && super.equals(c) && Objects.equals(this.baseDir, c.baseDir) && Objects.equals(this.keepBaseDir, c.keepBaseDir) && Objects.equals(this.enableNaming, c.enableNaming) && Objects.equals(this.forceMetaInf, c.forceMetaInf);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.baseDir, this.keepBaseDir, this.enableNaming, this.forceMetaInf);
    }
}

