/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.tomcat;

import com.github.mjeanroy.junit.servers.commons.core.CompositeClassLoader;
import com.github.mjeanroy.junit.servers.commons.lang.Strings;
import com.github.mjeanroy.junit.servers.exceptions.ServerInitializationException;
import com.github.mjeanroy.junit.servers.exceptions.ServerStartException;
import com.github.mjeanroy.junit.servers.exceptions.ServerStopException;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractEmbeddedServer;
import com.github.mjeanroy.junit.servers.tomcat.AbstractEmbeddedTomcatConfiguration;
import java.io.File;
import org.apache.catalina.Context;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.util.scan.StandardJarScanner;

public abstract class AbstractEmbeddedTomcat<CONFIGURATION extends AbstractEmbeddedTomcatConfiguration>
extends AbstractEmbeddedServer<Tomcat, CONFIGURATION> {
    private static final Logger log = LoggerFactory.getLogger(AbstractEmbeddedTomcat.class);
    private final Tomcat tomcat = this.initServer();
    private volatile Context context;

    protected AbstractEmbeddedTomcat(CONFIGURATION configuration) {
        super(configuration);
    }

    private Tomcat initServer() {
        log.debug("Initializing tomcat instance using configuration: {}", this.configuration);
        Tomcat tomcat = new Tomcat();
        tomcat.setBaseDir(((AbstractEmbeddedTomcatConfiguration)this.configuration).getBaseDir());
        tomcat.setPort(((AbstractEmbeddedTomcatConfiguration)this.configuration).getPort());
        tomcat.getHost().setAutoDeploy(true);
        tomcat.getHost().setDeployOnStartup(true);
        if (((AbstractEmbeddedTomcatConfiguration)this.configuration).isEnableNaming()) {
            tomcat.enableNaming();
        }
        return tomcat;
    }

    private Context initContext() {
        try {
            log.debug("Creating embedded tomcat context");
            return this.createContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServerInitializationException(ex);
        }
    }

    private Context createContext() {
        Context context;
        String webapp = ((AbstractEmbeddedTomcatConfiguration)this.configuration).getWebapp();
        String path = ((AbstractEmbeddedTomcatConfiguration)this.configuration).getPath();
        String classpath = ((AbstractEmbeddedTomcatConfiguration)this.configuration).getClasspath();
        boolean forceMetaInf = ((AbstractEmbeddedTomcatConfiguration)this.configuration).isForceMetaInf();
        ClassLoader parentClassLoader = ((AbstractEmbeddedTomcatConfiguration)this.configuration).getParentClassLoader();
        String descriptor = ((AbstractEmbeddedTomcatConfiguration)this.configuration).getOverrideDescriptor();
        File webappDirectory = new File(webapp);
        log.debug("Use tomcat webapp directory: {}", webappDirectory);
        if (webappDirectory.exists()) {
            ClassLoader tomcatParentClassLoader;
            String webappAbsolutePath = webappDirectory.getAbsolutePath();
            log.debug("Setting tomcat app base: {}", webappAbsolutePath);
            this.tomcat.getHost().setAppBase(webappAbsolutePath);
            log.debug("Getting context path from path={}", path);
            String trimmedPath = Strings.trim(path);
            String contextPath = Strings.isEmpty(trimmedPath) || trimmedPath.equals("/") ? "" : trimmedPath;
            log.debug("Adding tomcat webapp using contextPath={} and docBase={}", contextPath, webappAbsolutePath);
            context = this.tomcat.addWebapp(contextPath, webappAbsolutePath);
            if (Strings.isNotBlank(classpath)) {
                File file = new File(classpath);
                if (file.exists()) {
                    File metaInf = new File(file, "META-INF");
                    if (!metaInf.exists() && forceMetaInf) {
                        log.debug("Creating missing META-INF directory");
                        if (!metaInf.mkdir()) {
                            log.warn("Directory {} has not been created", metaInf);
                        }
                    }
                    String absolutePath = file.getAbsolutePath();
                    String webAppMount = "/WEB-INF/classes";
                    String archivePath = null;
                    StandardRoot root = new StandardRoot(context);
                    log.debug("Creating tomcat web resource set using base={} and internalPath={}", absolutePath, path);
                    root.createWebResourceSet(WebResourceRoot.ResourceSetType.PRE, "/WEB-INF/classes", absolutePath, archivePath, path);
                    log.debug("Set tomcat context resources: {}", root);
                    context.setResources((WebResourceRoot)root);
                    log.debug("Set tomcat jar scanner flag to scan all directories");
                    ((StandardJarScanner)context.getJarScanner()).setScanAllDirectories(true);
                } else {
                    log.warn("Specified classpath {} does not exist, or cannot be read", classpath);
                }
            }
            ClassLoader threadCl = Thread.currentThread().getContextClassLoader();
            if (parentClassLoader != null) {
                log.debug("Overriding tomcat parent classloader");
                tomcatParentClassLoader = new CompositeClassLoader(parentClassLoader, threadCl);
            } else {
                log.debug("Using current thread classload as tomcat parent classloader");
                tomcatParentClassLoader = threadCl;
            }
            context.setParentClassLoader(tomcatParentClassLoader);
            if (descriptor != null) {
                log.debug("Using web.xml descriptor: {}", descriptor);
                context.setAltDDName(descriptor);
            }
        } else {
            log.warn("Webapp directory {} does not exist or cannot be read", webappDirectory);
            context = null;
        }
        return context;
    }

    @Override
    public Tomcat getDelegate() {
        return this.tomcat;
    }

    @Override
    protected void doStart() {
        try {
            log.debug("Initializing tomcat context");
            this.context = this.initContext();
            log.debug("Starting tomcat");
            this.tomcat.start();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServerStartException(ex);
        }
    }

    @Override
    protected void doStop() {
        try {
            log.debug("Stopping tomcat");
            this.tomcat.stop();
            if (this.context != null) {
                log.debug("Destroying tomcat context");
                this.context.destroy();
                this.context = null;
            }
            if (!((AbstractEmbeddedTomcatConfiguration)this.configuration).isKeepBaseDir()) {
                log.debug("Deleting tomcat base directory: {}", ((AbstractEmbeddedTomcatConfiguration)this.configuration).getBaseDir());
                AbstractEmbeddedTomcat.deleteDirectory(((AbstractEmbeddedTomcatConfiguration)this.configuration).getBaseDir());
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServerStopException(ex);
        }
    }

    @Override
    public String getScheme() {
        return this.getConnector().getScheme();
    }

    @Override
    protected int doGetPort() {
        return this.getConnector().getLocalPort();
    }

    protected Context getContext() {
        return this.context;
    }

    private Connector getConnector() {
        return this.tomcat.getConnector();
    }

    private static void deleteDirectory(String path) {
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.exists()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        AbstractEmbeddedTomcat.deleteDirectory(f.getAbsolutePath());
                    }
                    if (f.delete()) continue;
                    log.warn("Directory {} has not been deleted", f);
                }
            }
            if (!file.delete()) {
                log.warn("File {} has not been deleted", file);
            }
        }
    }
}

