/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.okhttp3;

import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpRequest;
import com.github.mjeanroy.junit.servers.client.impl.okhttp3.OkHttpResponseFactory;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class OkHttpRequest
extends AbstractHttpRequest {
    private static final Logger log = LoggerFactory.getLogger(OkHttpRequest.class);
    private final OkHttpClient client;

    OkHttpRequest(OkHttpClient client, HttpMethod httpMethod, HttpUrl endpoint) {
        super(endpoint, httpMethod);
        this.client = client;
    }

    @Override
    protected HttpResponse doExecute() throws Exception {
        HttpUrl endpoint = this.getEndpoint();
        HttpUrl.Builder httpUrlBuilder = new HttpUrl.Builder().scheme(endpoint.getScheme()).host(endpoint.getHost()).port(endpoint.getPort()).addPathSegments(endpoint.getPath().substring(1));
        for (HttpParameter queryParam : this.queryParams.values()) {
            httpUrlBuilder.addEncodedQueryParameter(queryParam.getEncodedName(), queryParam.getEncodedValue());
        }
        Request.Builder builder = new Request.Builder().url(httpUrlBuilder.build());
        this.handleBody(builder);
        this.handleCookies(builder);
        this.handleHeaders(builder);
        Call call = this.client.newCall(builder.build());
        long start = System.nanoTime();
        try (Response response = call.execute();){
            long duration = System.nanoTime() - start;
            HttpResponse httpResponse = OkHttpResponseFactory.of(response, duration);
            return httpResponse;
        }
    }

    private void handleHeaders(Request.Builder builder) {
        for (HttpHeader h : this.headers.values()) {
            builder.header(h.getName(), h.serializeValues());
        }
    }

    private void handleCookies(Request.Builder builder) {
        if (!this.cookies.isEmpty()) {
            builder.addHeader("Cookie", Cookies.serialize(this.cookies));
        }
    }

    private void handleBody(Request.Builder builder) throws IOException {
        log.debug("Adding request body");
        RequestBody okhttpRequestBody = this.hasBody() ? this.createBody() : null;
        log.debug("Created body: {}", okhttpRequestBody);
        HttpMethod method = this.getMethod();
        if (okhttpRequestBody == null && method.isBodyAllowed()) {
            log.debug("Request method {} requires a body, but no one found, adding empty request body)", (Object)method);
            okhttpRequestBody = OkHttpRequest.createEmptyBody();
        }
        builder.method(method.getVerb(), okhttpRequestBody);
        if (this.body != null && this.body.getContentType() != null) {
            builder.header("Content-Type", this.body.getContentType());
        }
    }

    private RequestBody createBody() throws IOException {
        if (this.body == null) {
            return null;
        }
        log.debug("Creating OkHTTP request body from: {}", this.body);
        String rawContentType = this.body.getContentType();
        MediaType mediaType = rawContentType == null ? null : MediaType.parse((String)rawContentType);
        return RequestBody.create((MediaType)mediaType, (byte[])this.body.getBody());
    }

    private static RequestBody createEmptyBody() {
        return RequestBody.create(null, (String)"");
    }
}

