/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.async;

import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpResponse;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.asynchttpclient.Response;

final class AsyncHttpResponse
extends AbstractHttpResponse {
    private final Response response;

    AsyncHttpResponse(Response response, long duration) {
        super(duration);
        this.response = Preconditions.notNull(response, "Response");
    }

    @Override
    public int status() {
        return this.response.getStatusCode();
    }

    @Override
    protected String readResponseBody() {
        return this.response.getResponseBody();
    }

    @Override
    public Collection<HttpHeader> getHeaders() {
        HttpHeaders headers = this.response.getHeaders();
        ArrayList<HttpHeader> results = new ArrayList<HttpHeader>(headers.size());
        for (Map.Entry entry : headers) {
            String name = (String)entry.getKey();
            List values = headers.getAll(name);
            results.add(HttpHeader.header(name, values));
        }
        return results;
    }

    @Override
    public HttpHeader getHeader(String name) {
        List values = this.response.getHeaders((CharSequence)name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return HttpHeader.header(name, values);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("duration", this.getRequestDuration()).append("response", this.response).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AsyncHttpResponse) {
            AsyncHttpResponse r = (AsyncHttpResponse)o;
            return super.equals(r) && Objects.equals(this.response, r.response);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.response);
    }

    @Override
    protected boolean canEqual(AbstractHttpResponse o) {
        return o instanceof AsyncHttpResponse;
    }
}

