/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.apache;

import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpClient;
import com.github.mjeanroy.junit.servers.client.impl.apache.ApacheHttpRequest;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ApacheHttpClient
extends AbstractHttpClient {
    private final AtomicBoolean destroyed;
    private final CloseableHttpClient client;

    public static ApacheHttpClient defaultApacheHttpClient(EmbeddedServer<?> server) {
        HttpClientConfiguration configuration = HttpClientConfiguration.defaultConfiguration();
        return ApacheHttpClient.newApacheHttpClient(configuration, server);
    }

    public static ApacheHttpClient newApacheHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (!configuration.isFollowRedirect()) {
            httpClientBuilder.disableRedirectHandling();
        }
        CloseableHttpClient client = httpClientBuilder.build();
        return new ApacheHttpClient(configuration, server, client);
    }

    private ApacheHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server, CloseableHttpClient client) {
        super(configuration, server);
        this.client = Preconditions.notNull(client, "client");
        this.destroyed = new AtomicBoolean(false);
    }

    @Override
    protected HttpRequest buildRequest(HttpMethod httpMethod, HttpUrl endpoint) {
        return new ApacheHttpRequest((HttpClient)this.client, httpMethod, endpoint);
    }

    @Override
    public void doDestroy() throws Exception {
        if (this.destroyed.compareAndSet(false, true)) {
            this.client.close();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("configuration", this.getConfiguration()).append("server", this.getServer()).append("client", this.client).append("destroyed", this.destroyed).build();
    }
}

