/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.commons.io.Ios;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

final class HttpRequestBodyFile
implements HttpRequestBody {
    private final String contentType;
    private final Path path;

    static HttpRequestBodyFile of(File file) {
        Preconditions.notNull(file, "file");
        return HttpRequestBodyFile.of(file.toPath());
    }

    static HttpRequestBodyFile of(Path path) {
        Preconditions.notNull(path, "path");
        String contentType = com.github.mjeanroy.junit.servers.commons.lang.Objects.firstNonNull(Ios.guessContentType(path), "application/octet-stream");
        return new HttpRequestBodyFile(contentType, path);
    }

    static HttpRequestBodyFile of(File file, String contentType) {
        Preconditions.notNull(file, "file");
        Preconditions.notBlank(contentType, "content type");
        return new HttpRequestBodyFile(contentType, file.toPath());
    }

    static HttpRequestBodyFile of(Path path, String contentType) {
        Preconditions.notNull(path, "path");
        Preconditions.notBlank(contentType, "Content Type");
        return new HttpRequestBodyFile(contentType, path);
    }

    private HttpRequestBodyFile(String contentType, Path path) {
        this.contentType = contentType;
        this.path = path;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] getBody() throws IOException {
        return Ios.toBytes(this.path);
    }

    Path getPath() {
        return this.path;
    }

    String getFilename() {
        return this.path.getFileName().toString();
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("contentType", this.contentType).append("path", this.path).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequestBodyFile) {
            HttpRequestBodyFile b = (HttpRequestBodyFile)o;
            return Objects.equals(this.contentType, b.contentType) && Objects.equals(this.path, b.path);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.path);
    }
}

