/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.servers;

import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.Hook;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractConfigurationBuilder<SELF extends AbstractConfigurationBuilder<SELF, CONFIG>, CONFIG extends AbstractConfiguration> {
    private String path = "/";
    private String webapp = AbstractConfiguration.DEFAULT_WEBAPP;
    private int port = 0;
    private String classpath = ".";
    private ClassLoader parentClassLoader = null;
    private final Map<String, String> envProperties = new LinkedHashMap<String, String>();
    private final List<Hook> hooks = new ArrayList<Hook>();
    private String overrideDescriptor;

    protected AbstractConfigurationBuilder() {
    }

    protected abstract SELF self();

    public abstract CONFIG build();

    public String getPath() {
        return this.path;
    }

    public String getWebapp() {
        return this.webapp;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public int getPort() {
        return this.port;
    }

    public Map<String, String> getEnvProperties() {
        return this.envProperties;
    }

    public List<Hook> getHooks() {
        return this.hooks;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public String getOverrideDescriptor() {
        return this.overrideDescriptor;
    }

    public SELF withPath(String path) {
        this.path = Preconditions.notNull(path, "path");
        return this.self();
    }

    public SELF withWebapp(String webapp) {
        this.webapp = Preconditions.notNull(webapp, "webapp");
        return this.self();
    }

    public SELF withWebapp(File webapp) {
        Preconditions.notNull(webapp, "webapp");
        this.webapp = webapp.getAbsolutePath();
        return this.self();
    }

    public SELF withPort(int port) {
        this.port = Preconditions.positive(port, "port");
        return this.self();
    }

    public SELF withClasspath(String classpath) {
        this.classpath = classpath;
        return this.self();
    }

    public SELF withProperty(String name, String value) {
        this.envProperties.put(Preconditions.notBlank(name, "name"), Preconditions.notNull(value, "value"));
        return this.self();
    }

    public SELF withHook(Hook hook) {
        this.hooks.add(Preconditions.notNull(hook, "hook"));
        return this.self();
    }

    public SELF withParentClassLoader(Class<?> cls) {
        Preconditions.notNull(cls, "Base class");
        return this.withParentClassLoader(cls.getClassLoader());
    }

    public SELF withParentClasspath(URL classpath, URL ... others) {
        HashSet<URL> classpathUrls = new HashSet<URL>();
        classpathUrls.add(classpath);
        Collections.addAll(classpathUrls, others);
        return this.withParentClasspath(classpathUrls);
    }

    public SELF withParentClasspath(Collection<URL> classpath) {
        int nbUrls = classpath.size();
        if (nbUrls > 0) {
            URL[] urls = classpath.toArray(new URL[nbUrls]);
            URLClassLoader urlClassLoader = new URLClassLoader(urls);
            this.withParentClassLoader(urlClassLoader);
        }
        return this.self();
    }

    private SELF withParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this.self();
    }

    public SELF withOverrideDescriptor(String overrideDescriptor) {
        this.overrideDescriptor = overrideDescriptor;
        return this.self();
    }
}

