/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jupiter;

import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.engine.AnnotationsHandlerRunner;
import com.github.mjeanroy.junit.servers.engine.EmbeddedServerRunner;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import java.util.Objects;
import org.junit.jupiter.api.extension.ExtensionContext;

final class JunitServerExtensionContext
implements ExtensionContext.Store.CloseableResource {
    private final EmbeddedServerRunner runner;
    private final AnnotationsHandlerRunner annotationsHandler;

    JunitServerExtensionContext(EmbeddedServerRunner runner) {
        this.runner = Preconditions.notNull(runner, "runner");
        this.annotationsHandler = new AnnotationsHandlerRunner(runner.getServer(), (AbstractConfiguration)runner.getServer().getConfiguration());
    }

    EmbeddedServerRunner getRunner() {
        return this.runner;
    }

    AnnotationsHandlerRunner getAnnotationsHandler() {
        return this.annotationsHandler;
    }

    public void close() {
        this.runner.stop();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JunitServerExtensionContext) {
            JunitServerExtensionContext that = (JunitServerExtensionContext)o;
            return Objects.equals(this.runner, that.runner) && Objects.equals(this.annotationsHandler, that.annotationsHandler);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.runner, this.annotationsHandler);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("runner", this.runner).append("annotationsHandler", this.annotationsHandler).build();
    }
}

