/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty;

import com.github.mjeanroy.junit.servers.commons.core.CompositeClassLoader;
import com.github.mjeanroy.junit.servers.commons.core.Java;
import com.github.mjeanroy.junit.servers.commons.io.Ios;
import com.github.mjeanroy.junit.servers.commons.lang.Strings;
import com.github.mjeanroy.junit.servers.exceptions.ServerInitializationException;
import com.github.mjeanroy.junit.servers.exceptions.ServerStartException;
import com.github.mjeanroy.junit.servers.exceptions.ServerStopException;
import com.github.mjeanroy.junit.servers.jetty.AbstractEmbeddedJettyConfiguration;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractEmbeddedServer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;

public abstract class AbstractBaseEmbeddedJetty<CONTEXT extends ContextHandler, CONFIGURATION extends AbstractEmbeddedJettyConfiguration>
extends AbstractEmbeddedServer<Server, CONFIGURATION> {
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseEmbeddedJetty.class);
    private final Server server = this.initServer();
    private volatile CONTEXT webAppContext;
    private volatile ServerConnector connector;

    protected AbstractBaseEmbeddedJetty(CONFIGURATION configuration) {
        super(configuration);
    }

    private Server initServer() {
        log.debug("Initialize jetty server");
        Server server = new Server(((AbstractEmbeddedJettyConfiguration)this.configuration).getPort());
        server.setStopAtShutdown(((AbstractEmbeddedJettyConfiguration)this.configuration).isStopAtShutdown());
        server.setStopTimeout((long)((AbstractEmbeddedJettyConfiguration)this.configuration).getStopTimeout());
        return server;
    }

    private CONTEXT initContext() {
        try {
            log.debug("Initialize jetty webapp context");
            return this.createdWebAppContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServerInitializationException(ex);
        }
    }

    @Override
    public final Server getDelegate() {
        return this.server;
    }

    @Override
    protected final void doStart() {
        try {
            log.debug("Initializing embedded jetty context");
            this.webAppContext = this.initContext();
            log.debug("Starting embedded jetty");
            this.server.start();
            log.debug("Looking for embedded jetty server connector");
            this.connector = this.findConnector();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServerStartException(ex);
        }
    }

    private CONTEXT createdWebAppContext() throws Exception {
        ClassLoader classLoader;
        String path = ((AbstractEmbeddedJettyConfiguration)this.configuration).getPath();
        String webapp = ((AbstractEmbeddedJettyConfiguration)this.configuration).getWebapp();
        String classpath = ((AbstractEmbeddedJettyConfiguration)this.configuration).getClasspath();
        ClassLoader parentClassLoader = ((AbstractEmbeddedJettyConfiguration)this.configuration).getParentClassLoader();
        String overrideDescriptor = ((AbstractEmbeddedJettyConfiguration)this.configuration).getOverrideDescriptor();
        Resource baseResource = ((AbstractEmbeddedJettyConfiguration)this.configuration).getBaseResource();
        String containerJarPattern = ((AbstractEmbeddedJettyConfiguration)this.configuration).getContainerJarPattern();
        String webInfJarPattern = ((AbstractEmbeddedJettyConfiguration)this.configuration).getWebInfJarPattern();
        CONTEXT ctx = this.newWebAppContext();
        if (containerJarPattern != null) {
            log.debug("Setting jetty 'containerJarPattern' attribute: {}", containerJarPattern);
            this.setAttribute(ctx, this.containerJarPatternPropertyName(), containerJarPattern);
        } else if (Java.isPostJdk9()) {
            log.debug("Setting default jetty 'containerJarPattern' for JRE >= 9: {}");
            this.setAttribute(ctx, this.containerJarPatternPropertyName(), ".*\\.jar");
        }
        if (webInfJarPattern != null) {
            log.debug("Setting jetty 'WebInfJarPattern' attribute: {}", webInfJarPattern);
            this.setAttribute(ctx, this.webInfJarPatternPropertyName(), webInfJarPattern);
        }
        ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();
        if (parentClassLoader != null) {
            log.debug("Overriding jetty parent classloader");
            classLoader = new CompositeClassLoader(parentClassLoader, systemClassLoader);
        } else {
            log.debug("Using current thread classloader as jetty parent classloader");
            classLoader = systemClassLoader;
        }
        log.debug("Set jetty classloader");
        ctx.setClassLoader(classLoader);
        log.debug("Set jetty context path to: {}", path);
        ctx.setContextPath(path);
        Resource actualBaseResource = baseResource;
        if (actualBaseResource == null) {
            log.debug("Initializing default jetty base resource from: {}", webapp);
            actualBaseResource = this.newResource(ctx, webapp);
        }
        if (actualBaseResource != null && !actualBaseResource.exists()) {
            log.warn("Jetty base resource does not seem to exists: {}", actualBaseResource);
        }
        if (AbstractBaseEmbeddedJetty.isValidAndExistingResource(actualBaseResource)) {
            log.debug("Initializing jetty base resource: {}", actualBaseResource);
            ctx.setBaseResource(actualBaseResource);
        }
        if (overrideDescriptor != null) {
            log.debug("Set jetty descriptor: {}", overrideDescriptor);
            this.setOverrideDescriptor(ctx, overrideDescriptor);
        }
        log.debug("Initializing jetty configuration classes");
        this.configure(ctx);
        if (Strings.isNotBlank(classpath)) {
            log.debug("Adding jetty container resource: {}", classpath);
            File classes = new File(classpath);
            Resource containerResources = this.newResource(ctx, classes.toURI());
            this.addContainerResources(ctx, containerResources);
        }
        this.setInitParameter(ctx, "org.eclipse.jetty.servlet.Default.dirAllowed", ((AbstractEmbeddedJettyConfiguration)this.configuration).isDirAllowed());
        this.setParentLoaderPriority(ctx, true);
        Resource webappResource = this.newResource(ctx, webapp);
        if (AbstractBaseEmbeddedJetty.isValidAndExistingResource(webappResource)) {
            this.setWar(ctx, webappResource);
        }
        if (!AbstractBaseEmbeddedJetty.isValidAndExistingResource(actualBaseResource) && !AbstractBaseEmbeddedJetty.isValidAndExistingResource(webappResource)) {
            Resource commonBaseResource = this.findCommonBaseResource(ctx);
            log.warn("No resource base/war resource set, defaulting to: {}", commonBaseResource);
            ctx.setBaseResource(commonBaseResource);
        }
        ctx.setServer(this.server);
        this.server.setHandler(ctx);
        return ctx;
    }

    private Resource findCommonBaseResource(CONTEXT ctx) throws IOException {
        List<String> commonPaths = Arrays.asList(Ios.toFilePath("src", "main", "webapp"), Ios.toFilePath("src", "main", "resources", "static"), Ios.toFilePath("src", "main", "resources", "public"), Ios.toFilePath("src", "main", "resources", "static-root"), Ios.toFilePath("src", "main", "resources", "resources"), Ios.toFilePath("static", new String[0]), Ios.toFilePath("public", new String[0]), Ios.toFilePath("static-root", new String[0]), Ios.toFilePath("resources", new String[0]));
        for (String commonPath : commonPaths) {
            Resource resource = this.tryResource(ctx, commonPath);
            if (resource == null || !resource.exists()) continue;
            return resource;
        }
        return this.newResource(ctx, System.getProperty("user.dir"));
    }

    private Resource tryResource(CONTEXT ctx, String path) {
        try {
            return this.newResource(ctx, path);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean isValidAndExistingResource(Resource resource) {
        return resource != null && resource.exists();
    }

    @Override
    protected final void doStop() {
        try {
            log.debug("Stopping embedded jettu");
            this.server.stop();
            log.debug("Clearing jetty webapp context");
            this.webAppContext = null;
            log.debug("Clearing jetty server connector");
            this.connector = null;
        }
        catch (Exception ex) {
            throw new ServerStopException(ex);
        }
    }

    @Override
    public String getScheme() {
        return this.isStarted() ? this.server.getURI().getScheme() : super.getScheme();
    }

    @Override
    protected final int doGetPort() {
        return this.connector.getLocalPort();
    }

    protected final CONTEXT getWebAppContext() {
        return this.webAppContext;
    }

    protected abstract CONTEXT newWebAppContext();

    protected abstract String containerJarPatternPropertyName();

    protected abstract String webInfJarPatternPropertyName();

    protected abstract void setOverrideDescriptor(CONTEXT var1, String var2);

    protected abstract void configure(CONTEXT var1);

    protected abstract void setParentLoaderPriority(CONTEXT var1, boolean var2);

    protected abstract void setWar(CONTEXT var1, Resource var2);

    protected abstract void addContainerResources(CONTEXT var1, Resource var2);

    protected abstract void setAttribute(CONTEXT var1, String var2, String var3);

    protected abstract Resource newResource(CONTEXT var1, String var2) throws IOException;

    protected abstract Resource newResource(CONTEXT var1, URI var2) throws IOException;

    protected abstract void setInitParameter(CONTEXT var1, String var2, Object var3);

    private ServerConnector findConnector() {
        log.debug("Extracting jetty server connector");
        for (Connector connector : this.server.getConnectors()) {
            if (!(connector instanceof ServerConnector)) continue;
            return (ServerConnector)connector;
        }
        log.warn("Cannot find jetty server connector");
        return null;
    }
}

