/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons.reflect;

import com.github.mjeanroy.junit.servers.commons.reflect.Annotations;
import com.github.mjeanroy.junit.servers.exceptions.ReflectionException;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Reflections {
    private static final Logger log = LoggerFactory.getLogger(Reflections.class);

    private Reflections() {
    }

    public static List<Field> findAllFields(Class<?> type) {
        LinkedList<Field> fields = new LinkedList<Field>();
        if (type != null) {
            Collections.addAll(fields, type.getDeclaredFields());
            if (type.getSuperclass() != null) {
                fields.addAll(Reflections.findAllFields(type.getSuperclass()));
            }
        }
        return fields;
    }

    private static Stream<Field> findStaticFields(Class<?> type) {
        return Arrays.stream(type.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers()));
    }

    private static Stream<Method> findStaticMethods(Class<?> type) {
        return Arrays.stream(type.getDeclaredMethods()).filter(method -> Modifier.isStatic(method.getModifiers()));
    }

    public static List<Field> findStaticFieldsAnnotatedWith(Class<?> type, Class<? extends Annotation> annotationClass) {
        log.trace("Find static fields of {} annotated with {}", type, annotationClass);
        return Reflections.findStaticFields(type).filter(field -> Annotations.isAnnotationPresent(field, annotationClass)).collect(Collectors.toList());
    }

    public static List<Method> findStaticMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> annotationClass) {
        log.trace("Extract static methods of class {} annotated with {}", type, annotationClass);
        return Reflections.findStaticMethods(type).filter(method -> Annotations.isAnnotationPresent(method, annotationClass)).collect(Collectors.toList());
    }

    public static void setter(Object instance, Field field, Object value) {
        boolean forceAccess = false;
        try {
            if (!field.isAccessible()) {
                forceAccess = true;
                field.setAccessible(true);
            }
            field.set(instance, value);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
        finally {
            if (forceAccess) {
                field.setAccessible(false);
            }
        }
    }

    public static <T> T getter(Field field) {
        return Reflections.getter(null, field);
    }

    public static <T> T getter(Object target, Field field) {
        boolean forceAccess = false;
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
                forceAccess = true;
            }
            Object object = field.get(target);
            return (T)object;
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
        finally {
            if (forceAccess) {
                field.setAccessible(false);
            }
        }
    }

    public static <T> T invoke(Method method) {
        boolean forceAccess = false;
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
                forceAccess = true;
            }
            Object object = method.invoke(null, new Object[0]);
            return (T)object;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new ReflectionException(ex);
        }
        finally {
            if (forceAccess) {
                method.setAccessible(false);
            }
        }
    }
}

