/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyFile;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyMultipart;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyPart;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyPartBuilder;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class HttpRequestBodyMultipartBuilder {
    private String contentType = "multipart/form-data";
    private String boundaries;
    private final List<HttpRequestBodyPart> parts = new ArrayList<HttpRequestBodyPart>();

    HttpRequestBodyMultipartBuilder() {
    }

    public HttpRequestBodyMultipartBuilder withBoundaries(String boundaries) {
        this.boundaries = Preconditions.notBlank(boundaries, "boundaries");
        return this;
    }

    public HttpRequestBodyMultipartBuilder addFormDataPart(HttpRequestBody body, String name) {
        Preconditions.notNull(body, "body");
        Preconditions.notBlank(name, "name");
        HttpRequestBodyPartBuilder builder = HttpRequestBodyPartBuilder.of(body);
        if (body instanceof HttpRequestBodyFile) {
            builder.asFormData(name, ((HttpRequestBodyFile)body).getFilename());
        } else {
            builder.asFormData(name);
        }
        return this.addPart(builder.build());
    }

    public HttpRequestBodyMultipartBuilder addFormDataPart(HttpRequestBody body, String name, String filename) {
        Preconditions.notNull(body, "body");
        Preconditions.notBlank(name, "name");
        Preconditions.notBlank(filename, "filename");
        return this.addPart(HttpRequestBodyPartBuilder.of(body).asFormData(name, filename).build());
    }

    public HttpRequestBodyMultipartBuilder addFormDataPart(String name, String value) {
        Preconditions.notBlank(name, "name");
        Preconditions.notNull(value, "value");
        return this.addPart(HttpRequestBodyPartBuilder.of(value).asFormData(name).build());
    }

    public HttpRequestBodyMultipartBuilder addFormDataPart(File file, String name) {
        Preconditions.notNull(file, "file");
        Preconditions.notBlank(name, "name");
        return this.addPart(HttpRequestBodyPartBuilder.of(file).asFormData(name, file.getName()).build());
    }

    public HttpRequestBodyMultipartBuilder addFormDataPart(File file, String name, String filename) {
        Preconditions.notNull(file, "file");
        Preconditions.notBlank(name, "name");
        Preconditions.notBlank(filename, "filename");
        return this.addPart(HttpRequestBodyPartBuilder.of(file).asFormData(name, filename).build());
    }

    public HttpRequestBodyMultipartBuilder addFormDataPart(Path path, String name) {
        Preconditions.notNull(path, "path");
        Preconditions.notBlank(name, "name");
        return this.addPart(HttpRequestBodyPartBuilder.of(path).asFormData(name, path.getFileName().toString()).build());
    }

    public HttpRequestBodyMultipartBuilder addFormDataPart(Path path, String name, String filename) {
        Preconditions.notNull(path, "path");
        Preconditions.notBlank(name, "name");
        Preconditions.notBlank(filename, "filename");
        return this.addPart(HttpRequestBodyPartBuilder.of(path).asFormData(name, filename).build());
    }

    public HttpRequestBodyMultipartBuilder addPart(HttpRequestBodyPart part) {
        Preconditions.notNull(part, "part");
        this.parts.add(part);
        return this;
    }

    public HttpRequestBodyMultipartBuilder asMultipartFormData() {
        this.contentType = "multipart/form-data";
        return this;
    }

    public HttpRequestBodyMultipartBuilder asMultipartMixed() {
        this.contentType = "multipart/mixed";
        return this;
    }

    public HttpRequestBodyMultipartBuilder asMultipartAlternative() {
        this.contentType = "multipart/alternative";
        return this;
    }

    public HttpRequestBodyMultipartBuilder asMultipartDigest() {
        this.contentType = "multipart/digest";
        return this;
    }

    public HttpRequestBodyMultipartBuilder asMultipartParallel() {
        this.contentType = "multipart/parallel";
        return this;
    }

    public HttpRequestBody build() {
        return new HttpRequestBodyMultipart(this.contentType, this.boundaries, this.parts);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("contentType", this.contentType).append("boundaries", this.boundaries).append("parts", this.parts).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequestBodyMultipartBuilder) {
            HttpRequestBodyMultipartBuilder b = (HttpRequestBodyMultipartBuilder)o;
            return Objects.equals(this.contentType, b.contentType) && Objects.equals(this.boundaries, b.boundaries) && Objects.equals(this.parts, b.parts);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.boundaries, this.parts);
    }
}

