/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.Cookie;
import com.github.mjeanroy.junit.servers.commons.lang.Dates;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import java.util.HashMap;

public final class Cookies {
    private static final String SEPARATOR = "; ";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final String FIELD_SEPARATOR = ";";

    private Cookies() {
    }

    public static Cookie cookie(String name, String value) {
        return new Cookie.Builder(name, value).build();
    }

    public static Cookie cookie(String name, String value, String domain, String path, Long expires, Long maxAge, boolean secure, boolean httpOnly) {
        Cookie.Builder builder = new Cookie.Builder(name, value).domain(domain).path(path).secure(secure).httpOnly(httpOnly);
        if (expires != null) {
            builder.expires(expires);
        }
        if (maxAge != null) {
            builder.maxAge(maxAge);
        }
        return builder.build();
    }

    public static Cookie secureCookie(String name, String value, String domain, String path, Long expires, Long maxAge) {
        return Cookies.cookie(name, value, domain, path, expires, maxAge, true, true);
    }

    public static Cookie sessionCookie(String name, String value, String domain, String path) {
        return Cookies.cookie(name, value, domain, path, -1L, 0L, true, true);
    }

    public static Cookie read(String rawValue) {
        Preconditions.notBlank(rawValue, "Cookie value");
        String[] parts = rawValue.split(FIELD_SEPARATOR);
        String[] nameAndValue = parts[0].split(NAME_VALUE_SEPARATOR);
        if (nameAndValue.length != 2) {
            throw new IllegalArgumentException("Cookie must have a valid name and a valid value");
        }
        String name = nameAndValue[0].trim();
        String value = nameAndValue[1].trim();
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Cookie must have a valid name");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (parts.length > 1) {
            for (String part : parts) {
                String[] param = part.split(NAME_VALUE_SEPARATOR);
                String paramName = param[0].toLowerCase().trim();
                String paramValue = param.length == 2 ? param[1].trim() : "";
                params.put(paramName, paramValue);
            }
        }
        String domain = (String)params.get("domain");
        String path = (String)params.get("path");
        boolean secure = params.containsKey("secure");
        boolean httpOnly = params.containsKey("httponly");
        String maxAgeTt = (String)params.get("max-age");
        String expiresDate = (String)params.get("expires");
        Long maxAge = maxAgeTt == null ? null : Long.valueOf(maxAgeTt);
        Long expires = expiresDate != null ? Dates.getTime(expiresDate, "EEE, d MMM yyyy HH:mm:ss Z", "EEE, d-MMM-yyyy HH:mm:ss Z", "EEE, d/MMM/yyyy HH:mm:ss Z") : null;
        if (maxAge == null && expires == null) {
            maxAge = 0L;
        } else if (maxAge == null) {
            maxAge = expires - System.currentTimeMillis();
        }
        return Cookies.cookie(name, value, domain, path, expires, maxAge, secure, httpOnly);
    }

    public static String serialize(Iterable<Cookie> cookies) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Cookie cookie : cookies) {
            if (!first) {
                result.append(SEPARATOR);
            }
            String name = cookie.getName();
            String value = cookie.getValue();
            result.append(name).append(NAME_VALUE_SEPARATOR).append(value);
            first = false;
        }
        return result.toString();
    }
}

