/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback.json;

import com.github.loki4j.logback.json.RawJsonString;
import com.github.loki4j.pkg.dslplatform.json.NumberConverter;
import com.github.loki4j.pkg.dslplatform.json.RawJsonWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class JsonEventWriter {
    private final RawJsonWriter raw;

    public JsonEventWriter(int initialCapacity) {
        this.raw = new RawJsonWriter(initialCapacity);
    }

    public void writeBeginObject() {
        this.raw.writeByte((byte)123);
    }

    public void writeEndObject() {
        this.raw.writeByte((byte)125);
    }

    public void writeFieldSeparator() {
        this.raw.writeByte((byte)44);
    }

    public void writeObjectField(String fieldName, Object value) {
        this.writeFieldName(fieldName);
        this.writeObjectValue(value);
    }

    public void writeCustomField(String fieldName, Consumer<JsonEventWriter> write) {
        this.writeFieldName(fieldName);
        write.accept(this);
    }

    public void writeStringField(String fieldName, String value) {
        this.writeFieldName(fieldName);
        this.writeStringValue(value);
    }

    public void writeNumericField(String fieldName, long value) {
        this.writeFieldName(fieldName);
        this.writeNumericValue(value);
    }

    public <T> void writeArrayField(String fieldName, T[] values) {
        this.writeArrayField(fieldName, values, (JsonEventWriter w, T o) -> w.writeObjectValue(o));
    }

    public <T> void writeArrayField(String fieldName, T[] values, BiConsumer<JsonEventWriter, T> write) {
        this.writeArrayField(fieldName, Arrays.asList(values), write);
    }

    public <T> void writeArrayField(String fieldName, Iterable<T> values) {
        this.writeArrayField(fieldName, values, (JsonEventWriter w, T o) -> w.writeObjectValue(o));
    }

    public <T> void writeArrayField(String fieldName, Iterable<T> values, BiConsumer<JsonEventWriter, T> write) {
        this.writeFieldName(fieldName);
        this.writeIteratorValue(values.iterator(), write);
    }

    public void writeRawJsonField(String fieldName, String rawJson) {
        this.writeFieldName(fieldName);
        this.writeObjectValue(new RawJsonString(rawJson));
    }

    private void writeFieldName(String fieldName) {
        this.raw.writeString(fieldName);
        this.raw.writeByte((byte)58);
    }

    private void writeObjectValue(Object value) {
        if (value == null) {
            this.raw.writeNull();
            return;
        }
        if (value instanceof String) {
            this.raw.writeString((String)value);
        } else if (value instanceof Integer) {
            this.writeNumericValue(((Integer)value).longValue());
        } else if (value instanceof Long) {
            this.writeNumericValue((Long)value);
        } else if (value instanceof Boolean) {
            this.raw.writeBoolean((Boolean)value);
        } else if (value instanceof Iterator) {
            this.writeIteratorValue((Iterator)value, (w, o) -> w.writeObjectValue(o));
        } else if (value instanceof Iterable) {
            this.writeIteratorValue(((Iterable)value).iterator(), (w, o) -> w.writeObjectValue(o));
        } else if (value instanceof RawJsonString) {
            this.raw.writeRawAscii(((RawJsonString)value).value);
        } else {
            this.raw.writeString(value.toString());
        }
    }

    private void writeStringValue(String value) {
        if (value == null) {
            this.raw.writeNull();
        } else {
            this.raw.writeString(value);
        }
    }

    private void writeNumericValue(long value) {
        NumberConverter.serialize(value, this.raw);
    }

    private <T> void writeIteratorValue(Iterator<T> it, BiConsumer<JsonEventWriter, T> write) {
        this.writeBeginArray();
        while (it.hasNext()) {
            write.accept(this, (JsonEventWriter)it.next());
            if (!it.hasNext()) continue;
            this.writeArraySeparator();
        }
        this.writeEndArray();
    }

    private void writeBeginArray() {
        this.raw.writeByte((byte)91);
    }

    private void writeEndArray() {
        this.raw.writeByte((byte)93);
    }

    private void writeArraySeparator() {
        this.raw.writeByte((byte)44);
    }

    public String toString() {
        return this.raw.toString();
    }
}

