/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.pipeline;

import com.github.loki4j.client.util.Cache;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public class Loki4jMetrics {
    private final Timer appendTimer;
    private final Timer encodeTimer;
    private final Timer sendTimer;
    private final DistributionSummary eventsEncodedSummary;
    private final DistributionSummary bytesSentSummary;
    private final Counter batchesEncodedCounter;
    private final Counter batchesSentCounter;
    private final Counter droppedEventsCounter;
    private final Counter.Builder appendErrorsCounterBuilder;
    private final Cache.BoundAtomicMapCache<String, Counter> appendErrorsCounterCache = new Cache.BoundAtomicMapCache();
    private final Counter.Builder encodeErrorsCounterBuilder;
    private final Cache.BoundAtomicMapCache<String, Counter> encodeErrorsCounterCache = new Cache.BoundAtomicMapCache();
    private final Counter.Builder retryErrorsCounterBuilder;
    private final Cache.BoundAtomicMapCache<String, Counter> retryErrorsCounterCache = new Cache.BoundAtomicMapCache();
    private final Counter.Builder sendErrorsCounterBuilder;
    private final Cache.BoundAtomicMapCache<String, Counter> sendErrorsCounterCache = new Cache.BoundAtomicMapCache();

    public Loki4jMetrics(String appenderName, Supplier<Long> unsentEvents) {
        List<Tag> tags = Arrays.asList(Tag.of((String)"appender", (String)appenderName));
        this.appendTimer = Timer.builder((String)"loki4j.append.time").description("Time for a single event append operation").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.encodeTimer = Timer.builder((String)"loki4j.encode.time").description("Time for a batch encode operation").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.sendTimer = Timer.builder((String)"loki4j.send.time").description("Time for a HTTP send operation").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.eventsEncodedSummary = DistributionSummary.builder((String)"loki4j.encode.events").description("Number of log events processed by encoder").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.bytesSentSummary = DistributionSummary.builder((String)"loki4j.send.bytes").description("Size of batches sent to Loki").baseUnit("bytes").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.batchesEncodedCounter = Counter.builder((String)"loki4j.encode.batches").description("Number of batches processed by encoder").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.batchesSentCounter = Counter.builder((String)"loki4j.send.batches").description("Number of batches sent to Loki").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.droppedEventsCounter = Counter.builder((String)"loki4j.drop.events").description("Number of events dropped due to backpressure settings").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        Gauge.builder((String)"loki4j.unsent.events", () -> (Number)unsentEvents.get()).description("Current number of accepted but not yet sent events").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.appendErrorsCounterBuilder = Counter.builder((String)"loki4j.append.errors").description("Number of errors occurred while appending events").tags(tags);
        this.encodeErrorsCounterBuilder = Counter.builder((String)"loki4j.encode.errors").description("Number of errors occurred while encoding batches").tags(tags);
        this.retryErrorsCounterBuilder = Counter.builder((String)"loki4j.retry.errors").description("Number of errors occurred while retrying to send failed batches to Loki").tags(tags);
        this.sendErrorsCounterBuilder = Counter.builder((String)"loki4j.send.errors").description("Number of errors occurred while sending batches to Loki").tags(tags);
    }

    private void recordTimer(Timer timer, long startedNs) {
        timer.record(Duration.ofNanos(System.nanoTime() - startedNs));
    }

    public void eventAppended(long startedNs, boolean dropped) {
        this.recordTimer(this.appendTimer, startedNs);
        if (dropped) {
            this.droppedEventsCounter.increment();
        }
    }

    public void batchEncoded(long startedNs, int count) {
        this.recordTimer(this.encodeTimer, startedNs);
        this.eventsEncodedSummary.record((double)count);
        this.batchesEncodedCounter.increment();
    }

    public void appendFailed(Supplier<String> failure) {
        this.incrementErrorCounter(this.appendErrorsCounterBuilder, this.appendErrorsCounterCache, failure);
    }

    public void batchEncodeFailed(Supplier<String> failure) {
        this.incrementErrorCounter(this.encodeErrorsCounterBuilder, this.encodeErrorsCounterCache, failure);
    }

    public void sendRetryFailed(Supplier<String> failure) {
        this.incrementErrorCounter(this.retryErrorsCounterBuilder, this.retryErrorsCounterCache, failure);
    }

    public void batchSendFailed(Supplier<String> failure) {
        this.incrementErrorCounter(this.sendErrorsCounterBuilder, this.sendErrorsCounterCache, failure);
    }

    public void batchSent(long startedNs, int bytesCount) {
        this.recordTimer(this.sendTimer, startedNs);
        this.bytesSentSummary.record((double)bytesCount);
        this.batchesSentCounter.increment();
    }

    private void incrementErrorCounter(Counter.Builder builder, Cache.BoundAtomicMapCache<String, Counter> counterCache, Supplier<String> failure) {
        String failKey = failure.get();
        Counter errorCounter = counterCache.get(failKey, () -> builder.tag("reason", failKey).register((MeterRegistry)Metrics.globalRegistry));
        errorCounter.increment();
    }
}

