/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.batch;

import com.github.loki4j.client.batch.BatchCondition;
import com.github.loki4j.client.batch.LogRecord;
import com.github.loki4j.client.batch.LogRecordBatch;
import com.github.loki4j.client.batch.LogRecordStream;
import java.util.HashSet;

public final class Batcher {
    private final int maxSizeBytes;
    private final long maxTimeoutMs;
    private final LogRecord[] items;
    private int index = 0;
    private int sizeBytes = 0;
    private HashSet<LogRecordStream> streams = new HashSet();

    public Batcher(int maxItems, int maxSizeBytes, long maxTimeoutMs) {
        this.maxSizeBytes = maxSizeBytes;
        this.maxTimeoutMs = maxTimeoutMs;
        this.items = new LogRecord[maxItems];
    }

    public boolean validateLogRecordSize(LogRecord r) {
        int messageSize = r.messageUtf8SizeBytes + 24;
        int metadataSize = r.metadataUtf8SizeBytes + (r.metadata.length == 0 ? 0 : 1) * 24 + r.metadata.length * 2;
        int streamSize = r.stream.utf8SizeBytes + 8;
        return messageSize + metadataSize + streamSize <= this.maxSizeBytes;
    }

    private long estimateSizeBytes(LogRecord r, boolean dryRun) {
        long size = r.messageUtf8SizeBytes + 24;
        size += (long)(r.metadataUtf8SizeBytes + (r.metadata.length == 0 ? 0 : 1) * 24 + r.metadata.length * 2);
        if (!this.streams.contains(r.stream)) {
            size += (long)(r.stream.utf8SizeBytes + 8);
            if (!dryRun) {
                this.streams.add(r.stream);
            }
        }
        return size;
    }

    private void cutBatchAndReset(LogRecordBatch destination, BatchCondition condition) {
        destination.initFrom(this.items, this.index, this.streams.size(), condition, this.sizeBytes);
        this.index = 0;
        this.sizeBytes = 0;
        this.streams.clear();
    }

    public void checkSizeBeforeAdd(LogRecord input, LogRecordBatch destination) {
        long recordSizeBytes = this.estimateSizeBytes(input, true);
        if ((long)this.sizeBytes + recordSizeBytes > (long)this.maxSizeBytes) {
            this.cutBatchAndReset(destination, BatchCondition.MAX_BYTES);
        }
    }

    public void add(LogRecord input, LogRecordBatch destination) {
        this.items[this.index] = input;
        this.sizeBytes = (int)((long)this.sizeBytes + this.estimateSizeBytes(input, false));
        if (++this.index == this.items.length) {
            this.cutBatchAndReset(destination, BatchCondition.MAX_ITEMS);
        }
    }

    public void drain(long lastSentMs, LogRecordBatch destination) {
        long now = System.currentTimeMillis();
        if (this.index > 0 && now - lastSentMs > this.maxTimeoutMs) {
            this.cutBatchAndReset(destination, BatchCondition.DRAIN);
        }
    }

    public int getCapacity() {
        return this.items.length;
    }
}

