/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.annotation.InterceptMark;
import com.github.lianjiatech.retrofit.spring.boot.annotation.RetrofitClient;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitConfigBean;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitProperties;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseGlobalInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseLoggingInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BasePathMatchInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.HttpExceptionMessageFormatterInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.util.BeanExtendUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.event.Level;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class RetrofitFactoryBean<T>
implements FactoryBean<T>,
EnvironmentAware,
ApplicationContextAware {
    private Class<T> retrofitInterface;
    private Environment environment;
    private RetrofitProperties retrofitProperties;
    private RetrofitConfigBean retrofitConfigBean;
    private ApplicationContext applicationContext;

    public RetrofitFactoryBean(Class<T> retrofitInterface) {
        this.retrofitInterface = retrofitInterface;
    }

    public T getObject() throws Exception {
        this.checkRetrofitInterface(this.retrofitInterface);
        Retrofit retrofit = this.getRetrofit(this.retrofitInterface);
        return (T)retrofit.create(this.retrofitInterface);
    }

    private void checkRetrofitInterface(Class<T> retrofitInterface) {
        Method[] methods;
        Assert.isTrue((boolean)retrofitInterface.isInterface(), (String)"@RetrofitClient\u53ea\u80fd\u4f5c\u7528\u5728\u63a5\u53e3\u7c7b\u578b\u4e0a\uff01");
        for (Method method : methods = retrofitInterface.getMethods()) {
            Class<?> returnType = method.getReturnType();
            Assert.isTrue((!Void.TYPE.isAssignableFrom(returnType) ? 1 : 0) != 0, (String)("\u4e0d\u652f\u6301\u4f7f\u7528void\u5173\u952e\u5b57\u505a\u8fd4\u56de\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528java.lang.Void! method=" + method));
            if (!this.retrofitProperties.isDisableVoidReturnType()) continue;
            Assert.isTrue((!Void.class.isAssignableFrom(returnType) ? 1 : 0) != 0, (String)("\u5df2\u914d\u7f6e\u7981\u7528Void\u4f5c\u4e3a\u8fd4\u56de\u503c\uff0c\u8bf7\u6307\u5b9a\u5176\u4ed6\u8fd4\u56de\u7c7b\u578b\uff01method=" + method));
        }
    }

    public Class<T> getObjectType() {
        return this.retrofitInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    private synchronized ConnectionPool getConnectionPool(Class<?> retrofitClientInterfaceClass) {
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        String poolName = retrofitClient.poolName();
        Map<String, ConnectionPool> poolRegistry = this.retrofitConfigBean.getPoolRegistry();
        Assert.notNull(poolRegistry, (String)"poolRegistry\u4e0d\u5b58\u5728\uff01\u8bf7\u8bbe\u7f6eretrofitConfigBean.poolRegistry\uff01");
        ConnectionPool connectionPool = poolRegistry.get(poolName);
        Assert.notNull((Object)connectionPool, (String)("\u5f53\u524dpoolName\u5bf9\u5e94\u7684\u8fde\u63a5\u6c60\u4e0d\u5b58\u5728\uff01poolName = " + poolName));
        return connectionPool;
    }

    private synchronized OkHttpClient getOkHttpClient(Class<?> retrofitClientInterfaceClass) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        HttpExceptionMessageFormatterInterceptor httpExceptionMessageFormatterInterceptor;
        ConnectionPool connectionPool = this.getConnectionPool(retrofitClientInterfaceClass);
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout((long)retrofitClient.connectTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout((long)retrofitClient.readTimeoutMs(), TimeUnit.MILLISECONDS).writeTimeout((long)retrofitClient.writeTimeoutMs(), TimeUnit.MILLISECONDS).connectionPool(connectionPool);
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(this.findInterceptorByAnnotation(retrofitClientInterfaceClass));
        Collection<BaseGlobalInterceptor> globalInterceptors = this.retrofitConfigBean.getGlobalInterceptors();
        if (!CollectionUtils.isEmpty(globalInterceptors)) {
            interceptors.addAll(globalInterceptors);
        }
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        if (this.retrofitProperties.isEnableLog()) {
            Class<? extends BaseLoggingInterceptor> loggingInterceptorClass = this.retrofitProperties.getLoggingInterceptor();
            Constructor<? extends BaseLoggingInterceptor> constructor = loggingInterceptorClass.getConstructor(Level.class, BaseLoggingInterceptor.LogStrategy.class);
            BaseLoggingInterceptor loggingInterceptor = constructor.newInstance(new Object[]{retrofitClient.logLevel(), retrofitClient.logStrategy()});
            okHttpClientBuilder.addInterceptor((Interceptor)loggingInterceptor);
        }
        if ((httpExceptionMessageFormatterInterceptor = this.retrofitConfigBean.getHttpExceptionMessageFormatterInterceptor()) != null) {
            okHttpClientBuilder.addInterceptor((Interceptor)httpExceptionMessageFormatterInterceptor);
        }
        return okHttpClientBuilder.build();
    }

    private List<Interceptor> findInterceptorByAnnotation(Class<?> retrofitClientInterfaceClass) throws InstantiationException, IllegalAccessException {
        Annotation[] classAnnotations = retrofitClientInterfaceClass.getAnnotations();
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        ArrayList<Annotation> interceptAnnotations = new ArrayList<Annotation>();
        for (Annotation classAnnotation : classAnnotations) {
            Class<? extends Annotation> annotationType = classAnnotation.annotationType();
            if (!annotationType.isAnnotationPresent(InterceptMark.class)) continue;
            interceptAnnotations.add(classAnnotation);
        }
        for (Annotation interceptAnnotation : interceptAnnotations) {
            Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)interceptAnnotation);
            Object handler = annotationAttributes.get("handler");
            Assert.notNull(handler, (String)"@InterceptMark\u6807\u8bb0\u7684\u6ce8\u89e3\u5fc5\u987b\u914d\u7f6e: Class<? extends BasePathMatchInterceptor> handler()");
            Assert.notNull(annotationAttributes.get("include"), (String)"@InterceptMark\u6807\u8bb0\u7684\u6ce8\u89e3\u5fc5\u987b\u914d\u7f6e: String[] include()");
            Assert.notNull(annotationAttributes.get("exclude"), (String)"@InterceptMark\u6807\u8bb0\u7684\u6ce8\u89e3\u5fc5\u987b\u914d\u7f6e: String[] exclude()");
            Class interceptorClass = (Class)handler;
            BasePathMatchInterceptor interceptor = this.getInterceptorInstance(interceptorClass);
            HashMap annotationResolveAttributes = new HashMap(8);
            annotationAttributes.forEach((key, value) -> {
                if (value instanceof String) {
                    String newValue = this.environment.resolvePlaceholders((String)value);
                    annotationResolveAttributes.put(key, newValue);
                } else {
                    annotationResolveAttributes.put(key, value);
                }
            });
            BeanExtendUtils.populate(interceptor, annotationResolveAttributes);
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private BasePathMatchInterceptor getInterceptorInstance(Class<? extends BasePathMatchInterceptor> interceptorClass) throws IllegalAccessException, InstantiationException {
        try {
            return (BasePathMatchInterceptor)this.applicationContext.getBean(interceptorClass);
        }
        catch (BeansException e) {
            return interceptorClass.newInstance();
        }
    }

    private synchronized Retrofit getRetrofit(Class<?> retrofitClientInterfaceClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List<Converter.Factory> converterFactories;
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        String baseUrl = retrofitClient.baseUrl();
        baseUrl = this.environment.resolveRequiredPlaceholders(baseUrl);
        OkHttpClient client = this.getOkHttpClient(retrofitClientInterfaceClass);
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).client(client);
        List<CallAdapter.Factory> callAdapterFactories = this.retrofitConfigBean.getCallAdapterFactories();
        if (!CollectionUtils.isEmpty(callAdapterFactories)) {
            callAdapterFactories.forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addCallAdapterFactory(arg_0));
        }
        if (!CollectionUtils.isEmpty(converterFactories = this.retrofitConfigBean.getConverterFactories())) {
            converterFactories.forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addConverterFactory(arg_0));
        }
        return retrofitBuilder.build();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.retrofitConfigBean = (RetrofitConfigBean)applicationContext.getBean(RetrofitConfigBean.class);
        this.retrofitProperties = this.retrofitConfigBean.getRetrofitProperties();
    }
}

