/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.logic;

import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.logic.FunctionalInterfaceLogic;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public abstract class AbstractTypeDeclaration
implements ResolvedReferenceTypeDeclaration {
    public final Set<MethodUsage> getAllMethods() {
        HashSet<MethodUsage> methods = new HashSet<MethodUsage>();
        HashSet<String> methodsSignatures = new HashSet<String>();
        for (ResolvedMethodDeclaration methodDeclaration : this.getDeclaredMethods()) {
            MethodUsage methodUsage = new MethodUsage(methodDeclaration);
            methods.add(methodUsage);
            String signature = methodUsage.getSignature();
            String returnType = methodUsage.getDeclaration().getReturnType().describe();
            String enhancedSignature = String.format("%s %s", returnType, signature);
            methodsSignatures.add(enhancedSignature);
        }
        for (ResolvedReferenceType ancestor : this.getAllAncestors()) {
            List typeParametersMap = ancestor.getTypeParametersMap();
            Iterator iterator = ancestor.getDeclaredMethods().iterator();
            while (iterator.hasNext()) {
                MethodUsage mu;
                MethodUsage methodUsage = mu = (MethodUsage)iterator.next();
                for (Pair p : typeParametersMap) {
                    methodUsage = methodUsage.replaceTypeParameter((ResolvedTypeParameterDeclaration)p.a, (ResolvedType)p.b);
                }
                String signature = methodUsage.getSignature();
                String returnType = methodUsage.getDeclaration().getReturnType().describe();
                String enhancedSignature = String.format("%s %s", returnType, signature);
                if (methodsSignatures.contains(enhancedSignature)) continue;
                methodsSignatures.add(enhancedSignature);
                methods.add(mu);
            }
        }
        return methods;
    }

    public final boolean isFunctionalInterface() {
        return FunctionalInterfaceLogic.getFunctionalMethod((ResolvedReferenceTypeDeclaration)this).isPresent();
    }

    public static boolean isRecordType(Class<?> clazz) {
        try {
            Method isRecord = Class.class.getMethod("isRecord", new Class[0]);
            return (Boolean)isRecord.invoke(clazz, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Log.error((String)("Could not invoke isRecord on " + clazz.getName() + " due to " + e.getMessage()), (Supplier[])new Supplier[0]);
            return false;
        }
    }
}

