/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Deque;
import java.util.LinkedList;

public class CommentsParser {
    private static final int COLUMNS_PER_TAB = 4;

    public CommentsCollection parse(String source) throws IOException, UnsupportedEncodingException {
        ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes(Charset.defaultCharset()));
        return this.parse(in, Charset.defaultCharset().name());
    }

    public CommentsCollection parse(InputStream in, String charsetName) throws IOException, UnsupportedEncodingException {
        int r;
        boolean lastWasASlashR = false;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, charsetName));
        CommentsCollection comments = new CommentsCollection();
        ParserState parserState = new ParserState();
        State state = State.CODE;
        Comment currentLineComment = null;
        BlockComment currentBlockComment = null;
        StringBuffer currentContent = null;
        int currLine = 1;
        int currCol = 1;
        while ((r = br.read()) != -1) {
            char c = (char)r;
            if (c == '\r') {
                lastWasASlashR = true;
            } else {
                if (c == '\n' && lastWasASlashR) {
                    lastWasASlashR = false;
                    continue;
                }
                lastWasASlashR = false;
            }
            switch (state) {
                case CODE: {
                    if (parserState.isLastChar('/') && c == '/') {
                        currentLineComment = new LineComment();
                        currentLineComment.setBeginLine(currLine);
                        currentLineComment.setBeginColumn(currCol - 1);
                        state = State.IN_LINE_COMMENT;
                        currentContent = new StringBuffer();
                        break;
                    }
                    if (parserState.isLastChar('/') && c == '*') {
                        currentBlockComment = new BlockComment();
                        currentBlockComment.setBeginLine(currLine);
                        currentBlockComment.setBeginColumn(currCol - 1);
                        state = State.IN_BLOCK_COMMENT;
                        currentContent = new StringBuffer();
                        break;
                    }
                    if (c == '\"') {
                        state = State.IN_STRING;
                        break;
                    }
                    if (c != '\'') break;
                    state = State.IN_CHAR;
                    break;
                }
                case IN_LINE_COMMENT: {
                    if (c == '\n' || c == '\r') {
                        currentLineComment.setContent(currentContent.toString());
                        currentLineComment.setEndLine(currLine);
                        currentLineComment.setEndColumn(currCol);
                        comments.addComment((LineComment)currentLineComment);
                        state = State.CODE;
                        break;
                    }
                    currentContent.append(c);
                    break;
                }
                case IN_BLOCK_COMMENT: {
                    if (parserState.isLastChar('*') && c == '/' && (!parserState.isSecondToLastChar('/') || currentContent.length() > 0)) {
                        String content = currentContent.deleteCharAt(currentContent.toString().length() - 1).toString();
                        if (content.startsWith("*")) {
                            JavadocComment javadocComment = new JavadocComment();
                            javadocComment.setContent(content.substring(1));
                            javadocComment.setBeginLine(currentBlockComment.getBeginLine());
                            javadocComment.setBeginColumn(currentBlockComment.getBeginColumn());
                            javadocComment.setEndLine(currLine);
                            javadocComment.setEndColumn(currCol + 1);
                            comments.addComment(javadocComment);
                        } else {
                            currentBlockComment.setContent(content);
                            currentBlockComment.setEndLine(currLine);
                            currentBlockComment.setEndColumn(currCol + 1);
                            comments.addComment(currentBlockComment);
                        }
                        state = State.CODE;
                        break;
                    }
                    currentContent.append(c == '\r' ? (char)'\n' : (char)c);
                    break;
                }
                case IN_STRING: {
                    if (parserState.isLastChar('\\') || c != '\"') break;
                    state = State.CODE;
                    break;
                }
                case IN_CHAR: {
                    if (parserState.isLastChar('\\') || c != '\'') break;
                    state = State.CODE;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected");
                }
            }
            switch (c) {
                case '\n': 
                case '\r': {
                    ++currLine;
                    currCol = 1;
                    break;
                }
                case '\t': {
                    currCol += 4;
                    break;
                }
                default: {
                    ++currCol;
                }
            }
            if (state == State.IN_STRING && parserState.isLastChar('\\') && c == '\\') {
                parserState.reset();
                continue;
            }
            parserState.update(c);
        }
        if (state == State.IN_LINE_COMMENT) {
            currentLineComment.setContent(currentContent.toString());
            currentLineComment.setEndLine(currLine);
            currentLineComment.setEndColumn(currCol);
            comments.addComment((LineComment)currentLineComment);
        }
        return comments;
    }

    class ParserState {
        private Deque prevTwoChars = new LinkedList();

        ParserState() {
        }

        boolean isLastChar(char expectedChar) {
            return this.prevTwoChars.size() >= 1 && this.prevTwoChars.peekLast().equals(Character.valueOf(expectedChar));
        }

        public boolean isSecondToLastChar(char expectedChar) {
            return this.prevTwoChars.size() >= 1 && this.prevTwoChars.peekFirst().equals(Character.valueOf(expectedChar));
        }

        public void update(char c) {
            if (this.prevTwoChars.size() == 2) {
                this.prevTwoChars.remove();
            }
            this.prevTwoChars.add(Character.valueOf(c));
        }

        public void reset() {
            while (!this.prevTwoChars.isEmpty()) {
                this.prevTwoChars.removeFirst();
            }
        }
    }

    private static enum State {
        CODE,
        IN_LINE_COMMENT,
        IN_BLOCK_COMMENT,
        IN_STRING,
        IN_CHAR;

    }
}

