/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public final class ExtendsValidator
extends AbstractKeywordValidator {
    public ExtendsValidator(JsonNode digest) {
        super("extends");
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        SchemaTree tree = data.getSchema();
        JsonNode node = tree.getNode().get(this.keyword);
        if (node.isObject()) {
            FullData newData = data.withSchema(tree.append(JsonPointer.of((Object)this.keyword, (Object[])new Object[0])));
            processor.process(report, (MessageProvider)newData);
            return;
        }
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonPointer pointer = JsonPointer.of((Object)this.keyword, (Object[])new Object[]{index});
            FullData newData = data.withSchema(tree.append(pointer));
            processor.process(report, (MessageProvider)newData);
        }
    }

    @Override
    public String toString() {
        return this.keyword;
    }
}

