/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.RhinoHelper;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public final class RegexAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute INSTANCE = new RegexAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private RegexAttribute() {
        super("regex", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String value = data.getInstance().getNode().textValue();
        if (!RhinoHelper.regexIsValid((String)value)) {
            report.error(this.newMsg(data, bundle, "err.format.invalidRegex").putArgument("value", (Object)value));
        }
    }
}

