/*
 * Decompiled with CFR 0.152.
 */
package httl.web.webx;

import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.service.template.TemplateEngine;
import com.alibaba.citrus.service.template.TemplateException;
import com.alibaba.citrus.turbine.TurbineRunData;
import httl.web.WebEngine;
import httl.web.webx.ContextMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttlEngine
implements TemplateEngine {
    private final Properties properties = new Properties();
    private String path;
    private String templateEncoding;

    public void setPath(String path) {
        this.path = path;
    }

    public void setTemplateEncoding(String templateEncoding) {
        this.templateEncoding = templateEncoding;
    }

    public void setAdvancedProperties(Map<String, String> configuration) {
        this.properties.clear();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            this.properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public String[] getDefaultExtensions() {
        return new String[]{"httl"};
    }

    private String getTemplatePath(String name) {
        if (this.path == null) {
            return name;
        }
        return this.path + name;
    }

    public boolean exists(String templateName) {
        if (WebEngine.getServletContext() == null) {
            return templateName.endsWith(".httl");
        }
        return WebEngine.getEngine().hasResource(this.getTemplatePath(templateName));
    }

    public String getText(String templateName, TemplateContext context) throws TemplateException, IOException {
        StringWriter writer = new StringWriter();
        this.writeTo(templateName, context, writer);
        return writer.toString();
    }

    public void writeTo(String templateName, TemplateContext templateContext, OutputStream ostream) throws TemplateException, IOException {
        this.doWriteTo(templateName, templateContext, ostream);
    }

    public void writeTo(String templateName, TemplateContext templateContext, Writer writer) throws TemplateException, IOException {
        this.doWriteTo(templateName, templateContext, writer);
    }

    private void doWriteTo(String templateName, TemplateContext templateContext, Object out) throws TemplateException, IOException {
        try {
            String path = this.getTemplatePath(templateName);
            ContextMap map = new ContextMap(templateContext);
            TurbineRunData rundata = (TurbineRunData)templateContext.get("rundata");
            if (rundata != null) {
                HttpServletRequest request = rundata.getRequest();
                HttpServletResponse response = rundata.getResponse();
                if (rundata.getRequest() != null && rundata.getResponse() != null) {
                    WebEngine.setRequestAndResponse((HttpServletRequest)request, (HttpServletResponse)response);
                    WebEngine.getEngine().getTemplate(path, request.getLocale(), this.templateEncoding, (Object)map).render((Object)map, out);
                    return;
                }
            }
            WebEngine.getEngine().getTemplate(path, this.templateEncoding).render((Object)map, out);
        }
        catch (ParseException e) {
            throw new TemplateException(e.getMessage(), (Throwable)e);
        }
    }
}

