/*
 * Decompiled with CFR 0.152.
 */
package httl.web.struts;

import com.opensymphony.xwork2.util.ValueStack;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueStackMap
implements Map<String, Object> {
    private final ValueStack valueStack;

    public ValueStackMap(ValueStack valueStack) {
        if (valueStack == null) {
            throw new IllegalArgumentException("valueStack == null");
        }
        this.valueStack = valueStack;
    }

    @Override
    public Object get(Object key) {
        if ("request".equals(key) || "response".equals(key)) {
            return null;
        }
        return this.valueStack.findValue((String)key);
    }

    @Override
    public Object put(String key, Object value) {
        Object old = this.get(key);
        this.valueStack.set(key, value);
        return old;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        if (map != null) {
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                this.valueStack.set(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Object remove(Object key) {
        return this.put((String)key, (Object)null);
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.valueStack.getContext() == null ? null : this.valueStack.getContext().entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.valueStack.getContext() == null ? null : this.valueStack.getContext().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.valueStack.getContext() == null ? null : this.valueStack.getContext().values();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.valueStack.getContext() == null ? false : this.valueStack.getContext().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueStack.getContext() == null ? false : this.valueStack.getContext().containsKey(value);
    }

    @Override
    public int size() {
        return this.valueStack.getContext() == null ? 0 : this.valueStack.getContext().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }
}

