/*
 * Copyright 2011-2013 HTTL Team.
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *      http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package httl.web.springmvc;

import httl.web.WebEngine;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

/**
 * HttlViewResolver. (Integration, Singleton, ThreadSafe)
 * 
 * @author Liang Fei (liangfei0201 AT gmail DOT com)
 */
public class HttlViewResolver extends AbstractTemplateViewResolver implements InitializingBean {
	
	public HttlViewResolver() {
		setViewClass(requiredViewClass());
	}

	@Override
	protected Class<?> requiredViewClass() {
		return HttlView.class;
	}

	public void afterPropertiesSet() throws Exception {
		WebEngine.setServletContext(getServletContext());
		if (getSuffix() == null || getSuffix().length() == 0) {
			super.setSuffix(WebEngine.getTemplateSuffix());
		}
	}

}