/*
 * Decompiled with CFR 0.152.
 */
package httl.web.servlet;

import httl.web.WebEngine;
import java.io.IOException;
import java.text.ParseException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttlServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String suffix;

    public void init() throws ServletException {
        this.suffix = WebEngine.getTemplateSuffix((ServletContext)this.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebEngine.setRequestAndResponse((HttpServletRequest)request, (HttpServletResponse)response);
            WebEngine.getEngine().getTemplate(this.getTemplatePath(request), request.getLocale()).render((Object)response);
        }
        catch (ParseException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getTemplatePath(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null || path.length() == 0) {
            path = request.getServletPath();
        }
        if (path == null || path.length() == 0) {
            path = request.getRequestURI();
            String contextPath = request.getContextPath();
            if (contextPath != null && !"/".equals(contextPath) && path != null && path.startsWith(contextPath)) {
                path = path.substring(contextPath.length());
            }
        }
        if (path == null || path.length() == 0) {
            path = this.getRootPath();
        }
        if (this.suffix != null && this.suffix.length() > 0 && !path.endsWith(this.suffix)) {
            int i = path.lastIndexOf(46);
            if (i > 0 && i > path.lastIndexOf(47)) {
                path = path.substring(0, i);
            }
            path = path + this.suffix;
        }
        return path;
    }

    protected String getRootPath() {
        return "/index";
    }
}

