/*
 * Decompiled with CFR 0.152.
 */
package httl.web.servlet;

import httl.web.WebEngine;
import java.io.IOException;
import java.text.ParseException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttlFilter
implements Filter {
    private String suffix;

    public void init(FilterConfig config) throws ServletException {
        this.suffix = WebEngine.getTemplateSuffix((ServletContext)config.getServletContext());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        try {
            WebEngine.setRequestAndResponse((HttpServletRequest)request, (HttpServletResponse)response);
            WebEngine.getEngine().getTemplate(this.getTemplatePath(request), request.getLocale()).render((Object)response);
        }
        catch (ParseException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    protected String getTemplatePath(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null || path.length() == 0) {
            path = request.getServletPath();
        }
        if (path == null || path.length() == 0) {
            path = request.getRequestURI();
            String contextPath = request.getContextPath();
            if (contextPath != null && !"/".equals(contextPath) && path != null && path.startsWith(contextPath)) {
                path = path.substring(contextPath.length());
            }
        }
        if (path == null || path.length() == 0) {
            path = this.getRootPath();
        }
        if (this.suffix != null && this.suffix.length() > 0 && !path.endsWith(this.suffix)) {
            int i = path.lastIndexOf(46);
            if (i > 0 && i > path.lastIndexOf(47)) {
                path = path.substring(0, i);
            }
            path = path + this.suffix;
        }
        return path;
    }

    protected String getRootPath() {
        return "/index";
    }
}

