/*
 * Decompiled with CFR 0.152.
 */
package httl.script;

import httl.Engine;
import httl.script.HttlScriptEngine;
import httl.spi.Parser;
import httl.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttlScriptEngineFactory
implements ScriptEngineFactory {
    private final List<String> names = Arrays.asList("httl");
    private final List<String> extensions;
    private final List<String> mimeTypes;
    private final Engine engine;

    public HttlScriptEngineFactory() {
        String config = System.getProperty("httl.properties");
        this.engine = StringUtils.isEmpty((String)config) ? Engine.getEngine() : Engine.getEngine((String)config);
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("httl");
        ArrayList<String> mimeTypes = new ArrayList<String>();
        mimeTypes.add("text/httl");
        mimeTypes.add("text/html");
        for (String suffix : this.engine.getProperty("template.suffix", new String[]{".httl"})) {
            if (suffix.startsWith(".")) {
                suffix = suffix.substring(1);
            }
            if (!"httl".equals(suffix)) {
                extensions.add(suffix);
            }
            if ("httl".equals(suffix) || "html".equals(suffix)) continue;
            mimeTypes.add("text/" + suffix);
        }
        this.extensions = Collections.unmodifiableList(extensions);
        this.mimeTypes = Collections.unmodifiableList(mimeTypes);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new HttlScriptEngine(this, this.engine);
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public Object getParameter(String key) {
        return this.engine.getProperty(key);
    }

    @Override
    public String getEngineName() {
        return "httl";
    }

    @Override
    public String getEngineVersion() {
        return this.engine.getVersion();
    }

    @Override
    public String getLanguageName() {
        Parser parser = (Parser)this.engine.getProperty("parser", Parser.class);
        if (parser != null) {
            String suffix;
            String name = parser.getClass().getSimpleName();
            if (name.endsWith(suffix = Parser.class.getSimpleName())) {
                name = name.substring(0, name.length() - suffix.length());
            }
            return "httl-" + name.toLowerCase();
        }
        return "httl";
    }

    @Override
    public String getLanguageVersion() {
        return "1.0.0";
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String[] args) {
        StringBuilder buf = new StringBuilder();
        if (args != null && args.length > 0) {
            boolean first = true;
            for (String arg : args) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(arg);
            }
        }
        return obj + "." + m + "(" + buf.toString() + ")";
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "${" + toDisplay + "}";
    }

    @Override
    public String getProgram(String[] statements) {
        StringBuilder buf = new StringBuilder();
        for (String stat : statements) {
            buf.append(stat);
        }
        return buf.toString();
    }
}

