/*
 * Decompiled with CFR 0.152.
 */
package httl.script;

import httl.Engine;
import httl.script.HttlScript;
import httl.script.HttlScriptContext;
import httl.util.IOUtils;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;

public class HttlScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private final ScriptEngineFactory factory;
    private final Engine engine;

    public HttlScriptEngine(ScriptEngineFactory factory, Engine engine) {
        this.factory = factory;
        this.engine = engine;
        super.setContext(new HttlScriptContext());
    }

    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    public Bindings createBindings() {
        return this.getContext().getBindings(100);
    }

    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.compile(script).eval(context);
    }

    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.compile(reader).eval(context);
    }

    public CompiledScript compile(String script) throws ScriptException {
        try {
            return new HttlScript(this, this.engine.parseTemplate(script));
        }
        catch (ParseException e) {
            throw new ScriptException(e.getMessage());
        }
    }

    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            return this.compile(IOUtils.readToString((Reader)script));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }
}

