/*
 * Decompiled with CFR 0.152.
 */
package httl.script;

import httl.Context;
import httl.Template;
import httl.spi.resolvers.GlobalResolver;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttlScriptContext
implements ScriptContext {
    private static final List<Integer> SCOPES = Arrays.asList(200, 100);
    private Reader reader;
    private Writer writer;
    private Writer errorWriter;

    private Map<String, Object> getContext(int scope) {
        if (scope == 200) {
            return GlobalResolver.getGlobal();
        }
        return Context.getContext();
    }

    @Override
    public Object getAttribute(String name) {
        return this.getContext(100).get(name);
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this.getContext(scope).get(name);
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        return this.getContext(scope).remove(name);
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        this.getContext(scope).put(name, value);
    }

    @Override
    public Bindings getBindings(int scope) {
        return new SimpleBindings(this.getContext(scope));
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.getContext(scope).putAll(bindings);
    }

    @Override
    public int getAttributesScope(String name) {
        if (this.getContext(200).containsKey(name)) {
            return 200;
        }
        return 100;
    }

    @Override
    public List<Integer> getScopes() {
        return SCOPES;
    }

    @Override
    public Reader getReader() {
        Template template;
        if (this.reader == null && (template = Context.getContext().getTemplate()) != null) {
            try {
                return template.openReader();
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public Writer getWriter() {
        if (this.writer == null) {
            return (Writer)Context.getContext().getOut();
        }
        return this.writer;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Writer getErrorWriter() {
        if (this.errorWriter == null) {
            this.errorWriter = new PrintWriter(System.err);
        }
        return this.errorWriter;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }
}

