/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.stream;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.misc.CheckedIterator;
import com.github.housepower.jdbc.misc.CheckedSupplier;
import com.github.housepower.jdbc.protocol.DataResponse;
import com.github.housepower.jdbc.protocol.EOFStreamResponse;
import com.github.housepower.jdbc.protocol.Response;
import com.github.housepower.jdbc.stream.QueryResult;
import java.sql.SQLException;

public class ClickHouseQueryResult
implements QueryResult {
    private final CheckedSupplier<Response, SQLException> responseSupplier;
    private Block header;
    private boolean atEnd;

    public ClickHouseQueryResult(CheckedSupplier<Response, SQLException> responseSupplier) {
        this.responseSupplier = responseSupplier;
    }

    @Override
    public Block header() throws SQLException {
        this.ensureHeaderConsumed();
        return this.header;
    }

    @Override
    public CheckedIterator<DataResponse, SQLException> data() {
        return new CheckedIterator<DataResponse, SQLException>(){
            private DataResponse current;

            @Override
            public boolean hasNext() throws SQLException {
                return this.current != null || this.fill() != null;
            }

            @Override
            public DataResponse next() throws SQLException {
                return this.drain();
            }

            private DataResponse fill() throws SQLException {
                ClickHouseQueryResult.this.ensureHeaderConsumed();
                this.current = ClickHouseQueryResult.this.consumeDataResponse();
                return this.current;
            }

            private DataResponse drain() throws SQLException {
                if (this.current == null) {
                    this.fill();
                }
                DataResponse top = this.current;
                this.current = null;
                return top;
            }
        };
    }

    private void ensureHeaderConsumed() throws SQLException {
        if (this.header == null) {
            DataResponse firstDataResponse = this.consumeDataResponse();
            this.header = firstDataResponse != null ? firstDataResponse.block() : new Block();
        }
    }

    private DataResponse consumeDataResponse() throws SQLException {
        while (!this.atEnd) {
            Response response = this.responseSupplier.get();
            if (response instanceof DataResponse) {
                return (DataResponse)response;
            }
            if (!(response instanceof EOFStreamResponse) && response != null) continue;
            this.atEnd = true;
        }
        return null;
    }
}

