/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.statement;

import com.github.housepower.jdbc.ClickHouseConnection;
import com.github.housepower.jdbc.ClickHouseResultSet;
import com.github.housepower.jdbc.connect.NativeContext;
import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.log.Logger;
import com.github.housepower.jdbc.log.LoggerFactory;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.settings.ClickHouseConfig;
import com.github.housepower.jdbc.settings.SettingKey;
import com.github.housepower.jdbc.stream.QueryResult;
import com.github.housepower.jdbc.stream.ValuesInputFormat;
import com.github.housepower.jdbc.wrapper.SQLStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.time.Duration;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClickHouseStatement
implements SQLStatement {
    private static final Logger LOG = LoggerFactory.getLogger(ClickHouseStatement.class);
    private static final Pattern VALUES_REGEX = Pattern.compile("[V|v][A|a][L|l][U|u][E|e][S|s]\\s*\\(");
    private static final Pattern SELECT_DB_TABLE = Pattern.compile("(?i)FROM\\s+(\\S+\\.)?(\\S+)");
    private ResultSet lastResultSet;
    protected Block block;
    protected final ClickHouseConnection connection;
    protected final NativeContext nativeContext;
    private ClickHouseConfig cfg;
    private long maxRows;
    private String db;
    private String table = "unknown";
    private int updateCount = -1;
    private boolean isClosed = false;

    public ClickHouseStatement(ClickHouseConnection connection, NativeContext nativeContext) {
        this.connection = connection;
        this.nativeContext = nativeContext;
        this.cfg = connection.cfg();
        this.db = this.cfg.database();
    }

    @Override
    public boolean execute(String query) throws SQLException {
        LOG.debug("execute: {}", query);
        return this.executeQuery(query) != null;
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        LOG.debug("executeUpdate: {}", query);
        this.cfg.settings().put(SettingKey.max_result_rows, this.maxRows);
        this.cfg.settings().put(SettingKey.result_overflow_mode, "break");
        this.extractDBAndTableName(query);
        Matcher matcher = VALUES_REGEX.matcher(query);
        if (matcher.find() && query.trim().toUpperCase(Locale.ROOT).startsWith("INSERT")) {
            this.lastResultSet = null;
            String insertQuery = query.substring(0, matcher.end() - 1);
            this.block = this.getSampleBlock(insertQuery);
            this.block.initWriteBuffer();
            new ValuesInputFormat(matcher.end() - 1, query).fillBlock(this.block);
            this.updateCount = this.connection.sendInsertRequest(this.block);
            return this.updateCount;
        }
        this.updateCount = -1;
        QueryResult result = this.connection.sendQueryRequest(query, this.cfg);
        this.lastResultSet = new ClickHouseResultSet(this, this.cfg, this.db, this.table, result.header(), result.data());
        return 0;
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        LOG.debug("executeQuery: {}", query);
        this.executeUpdate(query);
        return this.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        LOG.debug("getUpdateCount: {}", this.updateCount);
        return this.updateCount;
    }

    @Override
    public ResultSet getResultSet() {
        LOG.debug("getResultSet: {}", this.lastResultSet);
        return this.lastResultSet;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        LOG.debug("getMoreResults", new Object[0]);
        this.updateCount = -1;
        if (this.lastResultSet != null) {
            this.lastResultSet.close();
            this.lastResultSet = null;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        LOG.debug("close Statement", new Object[0]);
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void cancel() throws SQLException {
        LOG.debug("cancel Statement", new Object[0]);
        this.close();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        Validate.isTrue(max >= 0, "Illegal maxRows value: " + max);
        this.maxRows = max;
    }

    @Override
    public int getQueryTimeout() {
        return (int)this.cfg.queryTimeout().getSeconds();
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.cfg = this.cfg.withQueryTimeout(Duration.ofSeconds(seconds));
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public Logger logger() {
        return LOG;
    }

    protected Block getSampleBlock(String insertQuery) throws SQLException {
        return this.connection.getSampleBlock(insertQuery);
    }

    private void extractDBAndTableName(String sql) {
        String upperSQL = sql.trim().toUpperCase(Locale.ROOT);
        if (upperSQL.startsWith("SELECT")) {
            Matcher m = SELECT_DB_TABLE.matcher(sql);
            if (m.find() && m.groupCount() == 2) {
                if (m.group(1) != null) {
                    this.db = m.group(1);
                }
                this.table = m.group(2);
            }
        } else if (upperSQL.startsWith("DESC")) {
            this.db = "system";
            this.table = "columns";
        } else if (upperSQL.startsWith("SHOW")) {
            this.db = "system";
            this.table = upperSQL.contains("TABLES") ? "tables" : "databases";
        }
    }
}

