/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.util;

import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.pinyin.model.CharToneInfo;
import com.github.houbb.pinyin.model.ToneItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class InnerToneHelper {
    private static final Map<Character, ToneItem> TONE_ITEM_MAP = new HashMap<Character, ToneItem>(34);

    private InnerToneHelper() {
    }

    public static ToneItem getToneItem(char c) {
        return TONE_ITEM_MAP.get(Character.valueOf(c));
    }

    public static CharToneInfo getCharToneInfo(String tone) {
        CharToneInfo charToneInfo = new CharToneInfo();
        charToneInfo.setIndex(-1);
        int length = tone.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = tone.charAt(i);
            ToneItem toneItem = InnerToneHelper.getToneItem(currentChar);
            if (!ObjectUtil.isNotNull((Object)toneItem)) continue;
            charToneInfo.setToneItem(toneItem);
            charToneInfo.setIndex(i);
            break;
        }
        return charToneInfo;
    }

    static {
        List allLines = StreamUtil.readAllLines((String)"/pinyin_dict_tone.txt");
        for (String line : allLines) {
            String[] strings = line.split(" ");
            ToneItem item = ToneItem.of(strings[0].charAt(0), Integer.parseInt(strings[1]));
            TONE_ITEM_MAP.put(Character.valueOf(strings[2].charAt(0)), item);
        }
    }
}

