/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.EnumSet;
import java.util.List;

@RedisCommand(value="pexpire")
class PExpire
extends AbstractRedisOperation {
    private final EnumSet<Options> options = EnumSet.noneOf(Options.class);

    PExpire(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    long getValue(List<Slice> params) {
        return Utils.convertToLong(new String(params.get(1).data()));
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    @Override
    protected Slice response() {
        long newTTL;
        for (int i = 2; i < this.params().size(); ++i) {
            Options value2;
            block13: {
                String opt = this.params().get(i).toString();
                for (Options value2 : Options.values()) {
                    if (!value2.toString().equalsIgnoreCase(opt)) {
                        continue;
                    }
                    break block13;
                }
                return Response.error("ERR Unsupported option " + opt);
            }
            this.options.add(value2);
        }
        if (this.options.contains((Object)Options.NX) && this.options.size() > 1) {
            return Response.error("ERR NX and XX, GT or LT options at the same time are not compatible");
        }
        if (this.options.contains((Object)Options.GT) && this.options.contains((Object)Options.LT)) {
            return Response.error("ERR GT and LT options at the same time are not compatible");
        }
        try {
            newTTL = this.getValue(this.params());
            Math.addExact(newTTL, this.base().getClock().millis());
        }
        catch (ArithmeticException e) {
            return Response.error(String.format("ERR invalid expire time in '%s' command", this.self().value()));
        }
        Slice key = this.params().get(0);
        boolean allow = this.base().exists(key);
        Long oldTTL = this.base().getTTL(this.params().get(0));
        if (oldTTL == null) {
            oldTTL = -2L;
        }
        if (this.options.contains((Object)Options.NX)) {
            boolean bl = allow = allow && oldTTL < 0L;
        }
        if (this.options.contains((Object)Options.XX)) {
            boolean bl = allow = allow && oldTTL >= 0L;
        }
        if (this.options.contains((Object)Options.LT) && oldTTL >= 0L) {
            boolean bl = allow = allow && newTTL < oldTTL;
        }
        if (this.options.contains((Object)Options.GT)) {
            boolean bl = allow = allow && oldTTL >= 0L && newTTL > oldTTL;
        }
        if (allow) {
            return Response.integer(this.base().setTTL(key, newTTL));
        }
        return Response.integer(0L);
    }

    static enum Options {
        XX,
        NX,
        LT,
        GT;

    }
}

