/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.hashes;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="hdel")
class HDel
extends AbstractRedisOperation {
    HDel(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        int count = 0;
        for (int i = 1; i < this.params().size(); ++i) {
            Slice currKey = this.params().get(i);
            Slice oldValue = this.base().getSlice(key, currKey);
            this.base().deleteValue(key, currKey);
            if (oldValue == null) continue;
            ++count;
        }
        return Response.integer(count);
    }
}

