/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.scripting.cjson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;

class Encode
extends OneArgFunction {
    private final Gson gson = new GsonBuilder().serializeNulls().create();

    Encode() {
    }

    public LuaValue call(LuaValue arg) {
        return LuaString.valueOf((String)this.gson.toJson(Encode.convert(arg)));
    }

    private static Object convert(LuaValue value) {
        if (value.isnil()) {
            return null;
        }
        if (value.isboolean()) {
            return value.toboolean();
        }
        if (value.islong()) {
            return value.tolong();
        }
        if (value.isnumber()) {
            return value.todouble();
        }
        if (value.istable() && Encode.isArray(value.checktable())) {
            return Encode.toList(value.checktable());
        }
        if (value.istable()) {
            return Encode.toMap(value.checktable());
        }
        return value.tojstring();
    }

    private static boolean isArray(LuaTable luaTable) {
        Varargs next;
        if (luaTable.length() == 0) {
            return false;
        }
        LuaValue key = LuaValue.NIL;
        Set indexes = IntStream.rangeClosed(1, luaTable.length()).boxed().collect(Collectors.toSet());
        while (!(key = (next = luaTable.next(key)).arg1()).isnil()) {
            if (key.isint() && indexes.remove(key.toint())) continue;
            return false;
        }
        return true;
    }

    private static Map<Object, Object> toMap(LuaTable table) {
        Varargs next;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        LuaValue key = LuaValue.NIL;
        while (!(key = (next = table.next(key)).arg1()).isnil()) {
            if (key.isboolean() || key.istable()) {
                throw new IllegalArgumentException("Unsupported key type: " + key.typename());
            }
            LuaValue value = next.arg(2);
            map.put(Encode.convert(key), Encode.convert(value));
        }
        return map;
    }

    private static List<Object> toList(LuaTable table) {
        return IntStream.rangeClosed(1, table.length()).mapToObj(arg_0 -> ((LuaTable)table).get(arg_0)).map(Encode::convert).collect(Collectors.toList());
    }
}

