/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.storage.ExpiringStorage;
import java.time.Clock;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Supplier;

public class RMHash
extends ExpiringStorage
implements RMDataStructure {
    private final LinkedHashMap<Slice, Slice> storedData = new LinkedHashMap();

    public RMHash(Supplier<Clock> clockSupplier) {
        super(clockSupplier, s -> {});
    }

    public Map<Slice, Slice> getStoredDataReadOnly() {
        this.storedData.entrySet().removeIf(e -> this.isKeyOutdated((Slice)e.getKey()));
        return Collections.unmodifiableMap(this.storedData);
    }

    public void put(Slice key, Slice data) {
        this.storedData.put(key, data);
    }

    @Override
    public void raiseTypeCastException() {
        throw new WrongValueTypeException("WRONGTYPE RMSortedSet value is used in the wrong place");
    }

    @Override
    public String getTypeName() {
        return "hash";
    }

    @Override
    public void delete(Slice key) {
        this.storedData.remove(key);
        super.delete(key);
    }

    @Override
    public boolean keyExists(Slice key) {
        return this.verifyKey(key);
    }

    public Slice get(Slice key) {
        if (!this.verifyKey(key)) {
            return null;
        }
        return this.storedData.get(key);
    }

    public boolean isEmpty() {
        return this.getStoredDataReadOnly().isEmpty();
    }

    private boolean verifyKey(Slice key) {
        Objects.requireNonNull(key);
        if (!this.storedData.containsKey(key)) {
            return false;
        }
        if (this.isKeyOutdated(key)) {
            this.delete(key);
            return false;
        }
        return true;
    }

    public int sizeIncludingExpired() {
        return this.storedData.size();
    }

    public boolean isLazilyExpired() {
        OptionalLong max;
        if (this.storedData.keySet().stream().allMatch(x$0 -> this.isKeyOutdated((Slice)x$0)) && (max = this.storedData.keySet().stream().mapToLong(this::getDeadline).max()).isPresent() && this.getMillis() - max.getAsLong() > 1000L) {
            this.storedData.clear();
            this.clear();
        }
        return this.storedData.isEmpty();
    }
}

