/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="zcount")
public class ZCount
extends AbstractByScoreOperation {
    public ZCount(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key);
        if (mapDBObj.isEmpty()) {
            return Response.integer(0L);
        }
        String start = this.params().get(1).toString();
        String end = this.params().get(2).toString();
        long result = mapDBObj.subset(this.getStartBound(start), this.getEndBound(end)).size();
        return Response.integer(result);
    }
}

