/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.Thawed;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.core.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.core.load.Dereferencing;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.configuration.URIDownloadersRegistry;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.EnumSet;
import java.util.Map;

public final class LoadingConfigurationBuilder
implements Thawed<LoadingConfiguration> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final EnumSet<JsonParser.Feature> DEFAULT_PARSER_FEATURES = EnumSet.noneOf(JsonParser.Feature.class);
    final URIDownloadersRegistry downloaders = new URIDownloadersRegistry();
    URITranslatorConfiguration translatorCfg;
    boolean enableCache = true;
    Dereferencing dereferencing;
    final Map<URI, JsonNode> preloadedSchemas;
    final EnumSet<JsonParser.Feature> parserFeatures;

    LoadingConfigurationBuilder() {
        this.translatorCfg = URITranslatorConfiguration.byDefault();
        this.dereferencing = Dereferencing.CANONICAL;
        this.preloadedSchemas = Maps.newHashMap();
        for (SchemaVersion version : SchemaVersion.values()) {
            this.preloadedSchemas.put(version.getLocation(), version.getSchema());
        }
        this.parserFeatures = EnumSet.copyOf(DEFAULT_PARSER_FEATURES);
    }

    LoadingConfigurationBuilder(LoadingConfiguration cfg) {
        this.downloaders.putAll(cfg.downloaders);
        this.translatorCfg = cfg.translatorCfg;
        this.dereferencing = cfg.dereferencing;
        this.preloadedSchemas = Maps.newHashMap(cfg.preloadedSchemas);
        this.parserFeatures = EnumSet.copyOf(cfg.parserFeatures);
        this.enableCache = cfg.enableCache;
    }

    public LoadingConfigurationBuilder setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
        return this;
    }

    public LoadingConfigurationBuilder addScheme(String scheme, URIDownloader downloader) {
        this.downloaders.put(scheme, downloader);
        return this;
    }

    public LoadingConfigurationBuilder removeScheme(String scheme) {
        this.downloaders.remove(scheme);
        return this;
    }

    public LoadingConfigurationBuilder setURITranslatorConfiguration(URITranslatorConfiguration translatorCfg) {
        this.translatorCfg = translatorCfg;
        return this;
    }

    public LoadingConfigurationBuilder dereferencing(Dereferencing dereferencing) {
        BUNDLE.checkNotNull((Object)dereferencing, "loadingCfg.nullDereferencingMode");
        this.dereferencing = dereferencing;
        return this;
    }

    public LoadingConfigurationBuilder preloadSchema(String uri, JsonNode schema) {
        BUNDLE.checkNotNull((Object)schema, "loadingCfg.nullSchema");
        URI key = LoadingConfigurationBuilder.getLocator(uri);
        BUNDLE.checkArgumentPrintf(this.preloadedSchemas.put(key, schema) == null, "loadingCfg.duplicateURI", new Object[]{key});
        return this;
    }

    public LoadingConfigurationBuilder preloadSchema(JsonNode schema) {
        JsonNode node = schema.path("id");
        BUNDLE.checkArgument(node.isTextual(), "loadingCfg.noIDInSchema");
        return this.preloadSchema(node.textValue(), schema);
    }

    public LoadingConfigurationBuilder addParserFeature(JsonParser.Feature feature) {
        BUNDLE.checkNotNull((Object)feature, "loadingCfg.nullJsonParserFeature");
        this.parserFeatures.add(feature);
        return this;
    }

    public LoadingConfigurationBuilder removeParserFeature(JsonParser.Feature feature) {
        BUNDLE.checkNotNull((Object)feature, "loadingCfg.nullJsonParserFeature");
        if (feature != JsonParser.Feature.AUTO_CLOSE_SOURCE) {
            this.parserFeatures.remove(feature);
        }
        return this;
    }

    public LoadingConfiguration freeze() {
        return new LoadingConfiguration(this);
    }

    private static URI getLocator(String input) {
        JsonRef ref;
        try {
            ref = JsonRef.fromString(input);
        }
        catch (JsonReferenceException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        BUNDLE.checkArgumentPrintf(ref.isAbsolute(), "jsonRef.notAbsolute", new Object[]{ref});
        return ref.getLocator();
    }

    static {
        for (JsonParser.Feature feature : JsonParser.Feature.values()) {
            if (!feature.enabledByDefault()) continue;
            DEFAULT_PARSER_FEATURES.add(feature);
        }
    }
}

