/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.Architecture;
import com.github.eirslett.maven.plugins.frontend.lib.OS;
import java.io.File;

class Platform {
    private final String nodeDownloadRoot;
    private final OS os;
    private final Architecture architecture;
    private final String classifier;

    public Platform(OS os, Architecture architecture) {
        this("https://nodejs.org/dist/", os, architecture, null);
    }

    public Platform(String nodeDownloadRoot, OS os, Architecture architecture, String classifier) {
        this.nodeDownloadRoot = nodeDownloadRoot;
        this.os = os;
        this.architecture = architecture;
        this.classifier = classifier;
    }

    public static Platform guess() {
        OS os = OS.guess();
        Architecture architecture = Architecture.guess();
        if (os == OS.Linux && new File("/etc/alpine-release").exists()) {
            return new Platform("https://unofficial-builds.nodejs.org/download/release/", os, architecture, "musl");
        }
        return new Platform(os, architecture);
    }

    public String getNodeDownloadRoot() {
        return this.nodeDownloadRoot;
    }

    public String getArchiveExtension() {
        return this.os.getArchiveExtension();
    }

    public String getCodename() {
        return this.os.getCodename();
    }

    public boolean isWindows() {
        return this.os == OS.Windows;
    }

    public boolean isMac() {
        return this.os == OS.Mac;
    }

    public String getLongNodeFilename(String nodeVersion, boolean archiveOnWindows) {
        if (this.isWindows() && !archiveOnWindows) {
            return "node.exe";
        }
        return "node-" + nodeVersion + "-" + this.getNodeClassifier();
    }

    public String getNodeDownloadFilename(String nodeVersion, boolean archiveOnWindows) {
        if (this.isWindows() && !archiveOnWindows) {
            if (this.architecture == Architecture.x64) {
                if (nodeVersion.startsWith("v0.")) {
                    return nodeVersion + "/x64/node.exe";
                }
                return nodeVersion + "/win-x64/node.exe";
            }
            if (nodeVersion.startsWith("v0.")) {
                return nodeVersion + "/node.exe";
            }
            return nodeVersion + "/win-x86/node.exe";
        }
        return nodeVersion + "/" + this.getLongNodeFilename(nodeVersion, archiveOnWindows) + "." + this.os.getArchiveExtension();
    }

    public String getNodeClassifier() {
        String result = this.isMac() && this.architecture == Architecture.arm64 ? this.getCodename() + "-" + Architecture.x64.name() : this.getCodename() + "-" + this.architecture.name();
        return this.classifier != null ? result + "-" + this.classifier : result;
    }
}

