/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.propertydescriptor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.CustomGetSetPropertyDescriptor;
import org.dozer.propertydescriptor.DozerPropertyDescriptor;
import org.dozer.propertydescriptor.FieldPropertyDescriptor;
import org.dozer.propertydescriptor.JavaBeanPropertyDescriptor;
import org.dozer.propertydescriptor.MapPropertyDescriptor;
import org.dozer.propertydescriptor.PropertyDescriptorCreationStrategy;
import org.dozer.propertydescriptor.SelfPropertyDescriptor;
import org.dozer.propertydescriptor.XmlBeanPropertyDescriptor;
import org.dozer.util.DozerConstants;
import org.dozer.util.MappingUtils;

public final class PropertyDescriptorFactory {
    private static final List<PropertyDescriptorCreationStrategy> pluggedDescriptorCreationStrategies = new ArrayList<PropertyDescriptorCreationStrategy>();

    private PropertyDescriptorFactory() {
    }

    public static DozerPropertyDescriptor getPropertyDescriptor(Class<?> clazz, String theGetMethod, String theSetMethod, String mapGetMethod, String mapSetMethod, boolean isAccessible, boolean isIndexed, int index, String name, String key, boolean isSelfReferencing, String oppositeFieldName, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer, String beanFactory) {
        DozerPropertyDescriptor desc = null;
        boolean isMapProperty = MappingUtils.isSupportedMap(clazz);
        if (name.equals("this") && (mapSetMethod != null || mapGetMethod != null || isMapProperty)) {
            String setMethod = isMapProperty ? "put" : mapSetMethod;
            String getMethod = isMapProperty ? "get" : mapGetMethod;
            desc = new MapPropertyDescriptor(clazz, name, isIndexed, index, setMethod, getMethod, key != null ? key : oppositeFieldName, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        } else if (isSelfReferencing) {
            desc = new SelfPropertyDescriptor(clazz);
        } else if (isAccessible) {
            desc = new FieldPropertyDescriptor(clazz, name, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        } else if (theSetMethod != null || theGetMethod != null) {
            desc = new CustomGetSetPropertyDescriptor(clazz, name, isIndexed, index, theSetMethod, theGetMethod, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        } else if (beanFactory != null && beanFactory.equals(DozerConstants.XML_BEAN_FACTORY)) {
            desc = new XmlBeanPropertyDescriptor(clazz, name, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        }
        if (desc != null) {
            return desc;
        }
        for (PropertyDescriptorCreationStrategy propertyDescriptorBuilder : new CopyOnWriteArrayList<PropertyDescriptorCreationStrategy>(pluggedDescriptorCreationStrategies)) {
            if (propertyDescriptorBuilder.isApplicable(clazz, name) && (desc = propertyDescriptorBuilder.buildFor(clazz, name, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer)) != null) break;
        }
        if (desc == null) {
            desc = new JavaBeanPropertyDescriptor(clazz, name, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        }
        return desc;
    }

    public static void addPluggedPropertyDescriptorCreationStrategy(PropertyDescriptorCreationStrategy strategy) {
        pluggedDescriptorCreationStrategies.add(strategy);
    }
}

