/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.converters;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dozer.cache.Cache;
import org.dozer.cache.CacheKeyFactory;
import org.dozer.converters.CustomConverterDescription;

public class CustomConverterContainer {
    private List<CustomConverterDescription> converters = new ArrayList<CustomConverterDescription>();

    public List<CustomConverterDescription> getConverters() {
        return this.converters;
    }

    public void setConverters(List<CustomConverterDescription> converters) {
        if (converters == null) {
            throw new NullPointerException("Converters can not be null!");
        }
        this.converters = converters;
    }

    public void addConverter(CustomConverterDescription converter) {
        this.getConverters().add(converter);
    }

    public Class getCustomConverter(Class<?> srcClass, Class<?> destClass, Cache converterTypeCache) {
        if (this.converters.isEmpty()) {
            return null;
        }
        Object cacheKey = CacheKeyFactory.createKey(destClass, srcClass);
        if (converterTypeCache.containsKey(cacheKey)) {
            return (Class)converterTypeCache.get(cacheKey);
        }
        Class src = ClassUtils.primitiveToWrapper(srcClass);
        Class dest = ClassUtils.primitiveToWrapper(destClass);
        Class appropriateConverter = this.findConverter(src, dest);
        converterTypeCache.put(cacheKey, appropriateConverter);
        return appropriateConverter;
    }

    public Class findConverter(Class src, Class dest) {
        for (CustomConverterDescription customConverter : this.converters) {
            Class<?> classA = customConverter.getClassA();
            Class<?> classB = customConverter.getClassB();
            if ((!classA.isAssignableFrom(dest) || !classB.isAssignableFrom(src)) && (!classA.isAssignableFrom(src) || !classB.isAssignableFrom(dest))) continue;
            return customConverter.getType();
        }
        return null;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

