/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap.generator;

import org.dozer.classmap.ClassMap;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.generator.MappingType;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.GenericFieldMap;
import org.dozer.util.MappingUtils;

public final class GeneratorUtils {
    private static final String CLASS = "class";
    private static final String CALLBACK = "callback";
    private static final String CALLBACKS = "callbacks";

    private GeneratorUtils() {
    }

    public static boolean shouldIgnoreField(String fieldName, Class<?> srcType, Class<?> destType) {
        if (CLASS.equals(fieldName)) {
            return true;
        }
        return !(!CALLBACK.equals(fieldName) && !CALLBACKS.equals(fieldName) || !MappingUtils.isProxy(srcType) && !MappingUtils.isProxy(destType));
    }

    public static void addGenericMapping(MappingType mappingType, ClassMap classMap, Configuration configuration, String srcName, String destName) {
        GenericFieldMap fieldMap = new GenericFieldMap(classMap);
        DozerField srcField = new DozerField(srcName, null);
        DozerField destField = new DozerField(destName, null);
        fieldMap.setSrcField(srcField);
        fieldMap.setDestField(destField);
        switch (mappingType) {
            case FIELD_TO_FIELD: {
                srcField.setAccessible(true);
                destField.setAccessible(true);
                break;
            }
            case FIELD_TO_SETTER: {
                srcField.setAccessible(true);
                break;
            }
        }
        MappingUtils.applyGlobalCopyByReference(configuration, fieldMap, classMap);
        classMap.addFieldMapping(fieldMap);
    }
}

