/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.hilbert;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.util.Arrays;
import org.davidmoten.hilbert.SmallHilbertCurve;
import org.davidmoten.hilbert.Util;

public final class HilbertCurve {
    private final int bits;
    private final int dimensions;
    private final int length;

    private HilbertCurve(int bits, int dimensions) {
        this.bits = bits;
        this.dimensions = dimensions;
        this.length = bits * dimensions;
    }

    public static Builder bits(int bits) {
        return new Builder(bits);
    }

    public static SmallHilbertCurve.Builder small() {
        return new SmallHilbertCurve.Builder();
    }

    public BigInteger index(long ... point) {
        Preconditions.checkArgument((point.length == this.dimensions ? 1 : 0) != 0);
        return this.toIndex(HilbertCurve.transposedIndex(this.bits, point));
    }

    public long[] point(BigInteger index) {
        Preconditions.checkNotNull((Object)index);
        Preconditions.checkArgument((index.signum() != -1 ? 1 : 0) != 0, (String)"index cannot be negative");
        return HilbertCurve.transposedIndexToPoint(this.bits, this.transpose(index));
    }

    public void point(BigInteger index, long[] x) {
        Preconditions.checkNotNull((Object)index);
        Preconditions.checkArgument((index.signum() != -1 ? 1 : 0) != 0, (String)"index cannot be negative");
        Util.zero(x);
        this.transpose(index, x);
        HilbertCurve.transposedIndexToPoint(this.bits, x);
    }

    public void point(long i, long[] x) {
        this.point(BigInteger.valueOf(i), x);
    }

    public long[] point(long index) {
        return this.point(BigInteger.valueOf(index));
    }

    @VisibleForTesting
    long[] transpose(BigInteger index) {
        long[] x = new long[this.dimensions];
        this.transpose(index, x);
        return x;
    }

    private void transpose(BigInteger index, long[] x) {
        byte[] b = index.toByteArray();
        for (int idx = 0; idx < 8 * b.length; ++idx) {
            if (((long)b[b.length - 1 - idx / 8] & 1L << idx % 8) == 0L) continue;
            int dim = (this.length - idx - 1) % this.dimensions;
            int shift = idx / this.dimensions % this.bits;
            int n = dim;
            x[n] = x[n] | 1L << shift;
        }
    }

    @VisibleForTesting
    static long[] transposedIndex(int bits, long ... point) {
        long t;
        int i;
        long q;
        long M = 1L << bits - 1;
        int n = point.length;
        long[] x = Arrays.copyOf(point, n);
        for (q = M; q > 1L; q >>= 1) {
            long p = q - 1L;
            for (i = 0; i < n; ++i) {
                if ((x[i] & q) != 0L) {
                    x[0] = x[0] ^ p;
                    continue;
                }
                t = (x[0] ^ x[i]) & p;
                x[0] = x[0] ^ t;
                int n2 = i;
                x[n2] = x[n2] ^ t;
            }
        }
        for (i = 1; i < n; ++i) {
            int n3 = i;
            x[n3] = x[n3] ^ x[i - 1];
        }
        t = 0L;
        for (q = M; q > 1L; q >>= 1) {
            if ((x[n - 1] & q) == 0L) continue;
            t ^= q - 1L;
        }
        i = 0;
        while (i < n) {
            int n4 = i++;
            x[n4] = x[n4] ^ t;
        }
        return x;
    }

    static long[] transposedIndexToPoint(int bits, long ... x) {
        int i;
        long N = 2L << bits - 1;
        int n = x.length;
        long t = x[n - 1] >> 1;
        for (i = n - 1; i > 0; --i) {
            int n2 = i;
            x[n2] = x[n2] ^ x[i - 1];
        }
        x[0] = x[0] ^ t;
        for (long q = 2L; q != N; q <<= 1) {
            long p = q - 1L;
            for (i = n - 1; i >= 0; --i) {
                if ((x[i] & q) != 0L) {
                    x[0] = x[0] ^ p;
                    continue;
                }
                t = (x[0] ^ x[i]) & p;
                x[0] = x[0] ^ t;
                int n3 = i;
                x[n3] = x[n3] ^ t;
            }
        }
        return x;
    }

    @VisibleForTesting
    BigInteger toIndex(long ... transposedIndex) {
        byte[] b = new byte[this.length];
        int bIndex = this.length - 1;
        long mask = 1L << this.bits - 1;
        for (int i = 0; i < this.bits; ++i) {
            for (int j = 0; j < transposedIndex.length; ++j) {
                if ((transposedIndex[j] & mask) != 0L) {
                    int n = this.length - 1 - bIndex / 8;
                    b[n] = (byte)(b[n] | 1 << bIndex % 8);
                }
                --bIndex;
            }
            mask >>= 1;
        }
        return new BigInteger(1, b);
    }

    public static final class Builder {
        final int bits;

        private Builder(int bits) {
            Preconditions.checkArgument((bits > 0 ? 1 : 0) != 0, (String)"bits must be greater than zero");
            Preconditions.checkArgument((bits < 64 ? 1 : 0) != 0, (String)"bits must be 63 or less");
            this.bits = bits;
        }

        public HilbertCurve dimensions(int dimensions) {
            Preconditions.checkArgument((dimensions > 1 ? 1 : 0) != 0, (String)"dimensions must be at least 2");
            return new HilbertCurve(this.bits, dimensions);
        }
    }
}

