/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.equator;

import com.github.dadiyang.equator.AbstractEquator;
import com.github.dadiyang.equator.FieldInfo;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FieldBaseEquator
extends AbstractEquator {
    private static final Map<Class<?>, Map<String, Field>> CACHE = new ConcurrentHashMap();

    public FieldBaseEquator() {
    }

    public FieldBaseEquator(boolean bothExistFieldOnly) {
        super(bothExistFieldOnly);
    }

    public FieldBaseEquator(List<String> includeFields, List<String> excludeFields, boolean bothExistFieldOnly) {
        super(includeFields, excludeFields, bothExistFieldOnly);
    }

    public FieldBaseEquator(List<String> includeFields, List<String> excludeFields) {
        super(includeFields, excludeFields);
    }

    @Override
    public List<FieldInfo> getDiffFields(Object first, Object second) {
        if (first == second) {
            return Collections.emptyList();
        }
        if (this.isSimpleField(first, second)) {
            return this.compareSimpleField(first, second);
        }
        Map<String, Field> firstFields = this.getAllFields(first);
        Map<String, Field> secondFields = this.getAllFields(second);
        Set<String> allFieldNames = first == null ? secondFields.keySet() : (second == null ? firstFields.keySet() : this.getAllFieldNames(firstFields.keySet(), secondFields.keySet()));
        LinkedList<FieldInfo> diffFields = new LinkedList<FieldInfo>();
        for (String fieldName : allFieldNames) {
            try {
                Field firstField = firstFields.getOrDefault(fieldName, null);
                Field secondField = secondFields.getOrDefault(fieldName, null);
                Object firstVal = null;
                Class<?> firstType = null;
                Class<?> secondType = null;
                Object secondVal = null;
                if (firstField != null) {
                    firstField.setAccessible(true);
                    firstVal = firstField.get(first);
                    firstType = firstField.getType();
                }
                if (secondField != null) {
                    secondField.setAccessible(true);
                    secondVal = secondField.get(second);
                    secondType = secondField.getType();
                }
                FieldInfo fieldInfo = new FieldInfo(fieldName, firstType, secondType);
                fieldInfo.setFirstVal(firstVal);
                fieldInfo.setSecondVal(secondVal);
                if (this.isFieldEquals(fieldInfo)) continue;
                diffFields.add(fieldInfo);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("\u83b7\u53d6\u5c5e\u6027\u8fdb\u884c\u6bd4\u5bf9\u53d1\u751f\u5f02\u5e38: " + fieldName, e);
            }
        }
        return diffFields;
    }

    private Map<String, Field> getAllFields(Object obj) {
        if (obj == null) {
            return Collections.emptyMap();
        }
        return CACHE.computeIfAbsent(obj.getClass(), k -> {
            HashMap<String, Field> fieldMap = new HashMap<String, Field>(8);
            for (Class cls = k; cls != Object.class; cls = cls.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = cls.getDeclaredFields()) {
                    if (field.isSynthetic()) continue;
                    fieldMap.put(field.getName(), field);
                }
            }
            return fieldMap;
        });
    }
}

