/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.core;

import java.util.HashMap;
import java.util.Map;
import redis.embedded.core.ExecutableProvider;
import redis.embedded.model.Architecture;
import redis.embedded.model.OS;
import redis.embedded.model.OsArchitecture;

public class ExecutableProviderBuilder {
    private final Map<OsArchitecture, String> map = new HashMap<OsArchitecture, String>();

    public ExecutableProviderBuilder add2_8_19() {
        this.map.putAll(ExecutableProvider.newRedis2_8_19Map());
        return this;
    }

    public ExecutableProviderBuilder put(OS os, String executable) {
        for (Architecture arch : Architecture.values()) {
            this.map.put(new OsArchitecture(os, arch), executable);
        }
        return this;
    }

    public ExecutableProviderBuilder put(OS os, Architecture arch, String executable) {
        this.map.put(new OsArchitecture(os, arch), executable);
        return this;
    }

    public ExecutableProvider build() {
        return ExecutableProvider.newJarResourceProvider(this.map);
    }
}

