/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool.atomic;

import cn.beecp.pool.atomic.AtomicUnsafeUtil;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AtomicReferenceFieldUpdaterImpl<T, V>
extends AtomicReferenceFieldUpdater<T, V> {
    private static final Unsafe unsafe = AtomicUnsafeUtil.unsafe;
    private final long offset;
    private final Class<V> fieldType;

    private AtomicReferenceFieldUpdaterImpl(long offset, Class<V> fieldType) {
        this.offset = offset;
        this.fieldType = fieldType;
    }

    public static <T, V> AtomicReferenceFieldUpdater<T, V> newUpdater(Class<T> beanClass, Class<V> fieldType, String fieldName) {
        try {
            return new AtomicReferenceFieldUpdaterImpl<T, V>(unsafe.objectFieldOffset(beanClass.getDeclaredField(fieldName)), fieldType);
        }
        catch (Throwable e) {
            return AtomicReferenceFieldUpdater.newUpdater(beanClass, fieldType, fieldName);
        }
    }

    @Override
    public final boolean compareAndSet(T bean, V expect, V update) {
        return unsafe.compareAndSwapObject(bean, this.offset, expect, update);
    }

    @Override
    public final boolean weakCompareAndSet(T bean, V expect, V update) {
        return unsafe.compareAndSwapObject(bean, this.offset, expect, update);
    }

    @Override
    public final void set(T bean, V newValue) {
        unsafe.putObjectVolatile(bean, this.offset, newValue);
    }

    @Override
    public final void lazySet(T bean, V newValue) {
        unsafe.putOrderedObject(bean, this.offset, newValue);
    }

    @Override
    public final V get(T bean) {
        return this.fieldType.cast(unsafe.getObjectVolatile(bean, this.offset));
    }
}

