/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool.atomic;

import cn.beecp.pool.atomic.AtomicUnsafeUtil;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AtomicIntegerFieldUpdaterImpl<T>
extends AtomicIntegerFieldUpdater<T> {
    private static final Unsafe unsafe = AtomicUnsafeUtil.unsafe;
    private final long offset;

    private AtomicIntegerFieldUpdaterImpl(long offset) {
        this.offset = offset;
    }

    public static <T> AtomicIntegerFieldUpdater<T> newUpdater(Class<T> beanClass, String fieldName) {
        try {
            return new AtomicIntegerFieldUpdaterImpl<T>(unsafe.objectFieldOffset(beanClass.getDeclaredField(fieldName)));
        }
        catch (Throwable e) {
            return AtomicIntegerFieldUpdater.newUpdater(beanClass, fieldName);
        }
    }

    @Override
    public final boolean compareAndSet(T bean, int expect, int update) {
        return unsafe.compareAndSwapInt(bean, this.offset, expect, update);
    }

    @Override
    public final boolean weakCompareAndSet(T bean, int expect, int update) {
        return unsafe.compareAndSwapInt(bean, this.offset, expect, update);
    }

    @Override
    public final void set(T bean, int newValue) {
        unsafe.putIntVolatile(bean, this.offset, newValue);
    }

    @Override
    public final void lazySet(T bean, int newValue) {
        unsafe.putOrderedInt(bean, this.offset, newValue);
    }

    @Override
    public final int get(T bean) {
        return unsafe.getIntVolatile(bean, this.offset);
    }
}

